/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.lakeformation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The permissions granted or revoked on a resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PrincipalResourcePermissions implements SdkPojo, Serializable,
        ToCopyableBuilder<PrincipalResourcePermissions.Builder, PrincipalResourcePermissions> {
    private static final SdkField<DataLakePrincipal> PRINCIPAL_FIELD = SdkField
            .<DataLakePrincipal> builder(MarshallingType.SDK_POJO).memberName("Principal")
            .getter(getter(PrincipalResourcePermissions::principal)).setter(setter(Builder::principal))
            .constructor(DataLakePrincipal::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final SdkField<Resource> RESOURCE_FIELD = SdkField.<Resource> builder(MarshallingType.SDK_POJO)
            .memberName("Resource").getter(getter(PrincipalResourcePermissions::resource)).setter(setter(Builder::resource))
            .constructor(Resource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resource").build()).build();

    private static final SdkField<List<String>> PERMISSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(PrincipalResourcePermissions::permissionsAsStrings))
            .setter(setter(Builder::permissionsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PERMISSIONS_WITH_GRANT_OPTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PermissionsWithGrantOption")
            .getter(getter(PrincipalResourcePermissions::permissionsWithGrantOptionAsStrings))
            .setter(setter(Builder::permissionsWithGrantOptionWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PermissionsWithGrantOption").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DetailsMap> ADDITIONAL_DETAILS_FIELD = SdkField.<DetailsMap> builder(MarshallingType.SDK_POJO)
            .memberName("AdditionalDetails").getter(getter(PrincipalResourcePermissions::additionalDetails))
            .setter(setter(Builder::additionalDetails)).constructor(DetailsMap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdditionalDetails").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD,
            RESOURCE_FIELD, PERMISSIONS_FIELD, PERMISSIONS_WITH_GRANT_OPTION_FIELD, ADDITIONAL_DETAILS_FIELD));

    private static final long serialVersionUID = 1L;

    private final DataLakePrincipal principal;

    private final Resource resource;

    private final List<String> permissions;

    private final List<String> permissionsWithGrantOption;

    private final DetailsMap additionalDetails;

    private PrincipalResourcePermissions(BuilderImpl builder) {
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.permissions = builder.permissions;
        this.permissionsWithGrantOption = builder.permissionsWithGrantOption;
        this.additionalDetails = builder.additionalDetails;
    }

    /**
     * <p>
     * The Data Lake principal to be granted or revoked permissions.
     * </p>
     * 
     * @return The Data Lake principal to be granted or revoked permissions.
     */
    public DataLakePrincipal principal() {
        return principal;
    }

    /**
     * <p>
     * The resource where permissions are to be granted or revoked.
     * </p>
     * 
     * @return The resource where permissions are to be granted or revoked.
     */
    public Resource resource() {
        return resource;
    }

    /**
     * <p>
     * The permissions to be granted or revoked on the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The permissions to be granted or revoked on the resource.
     */
    public List<Permission> permissions() {
        return PermissionListCopier.copyStringToEnum(permissions);
    }

    /**
     * Returns true if the Permissions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions to be granted or revoked on the resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The permissions to be granted or revoked on the resource.
     */
    public List<String> permissionsAsStrings() {
        return permissions;
    }

    /**
     * <p>
     * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissionsWithGrantOption()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
     */
    public List<Permission> permissionsWithGrantOption() {
        return PermissionListCopier.copyStringToEnum(permissionsWithGrantOption);
    }

    /**
     * Returns true if the PermissionsWithGrantOption property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasPermissionsWithGrantOption() {
        return permissionsWithGrantOption != null && !(permissionsWithGrantOption instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissionsWithGrantOption()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
     */
    public List<String> permissionsWithGrantOptionAsStrings() {
        return permissionsWithGrantOption;
    }

    /**
     * <p>
     * This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>.
     * Currently returns only as a RAM share resource ARN.
     * </p>
     * 
     * @return This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>.
     *         Currently returns only as a RAM share resource ARN.
     */
    public DetailsMap additionalDetails() {
        return additionalDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(permissionsWithGrantOptionAsStrings());
        hashCode = 31 * hashCode + Objects.hashCode(additionalDetails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PrincipalResourcePermissions)) {
            return false;
        }
        PrincipalResourcePermissions other = (PrincipalResourcePermissions) obj;
        return Objects.equals(principal(), other.principal()) && Objects.equals(resource(), other.resource())
                && Objects.equals(permissionsAsStrings(), other.permissionsAsStrings())
                && Objects.equals(permissionsWithGrantOptionAsStrings(), other.permissionsWithGrantOptionAsStrings())
                && Objects.equals(additionalDetails(), other.additionalDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("PrincipalResourcePermissions").add("Principal", principal()).add("Resource", resource())
                .add("Permissions", permissionsAsStrings())
                .add("PermissionsWithGrantOption", permissionsWithGrantOptionAsStrings())
                .add("AdditionalDetails", additionalDetails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "Resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissionsAsStrings()));
        case "PermissionsWithGrantOption":
            return Optional.ofNullable(clazz.cast(permissionsWithGrantOptionAsStrings()));
        case "AdditionalDetails":
            return Optional.ofNullable(clazz.cast(additionalDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PrincipalResourcePermissions, T> g) {
        return obj -> g.apply((PrincipalResourcePermissions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PrincipalResourcePermissions> {
        /**
         * <p>
         * The Data Lake principal to be granted or revoked permissions.
         * </p>
         * 
         * @param principal
         *        The Data Lake principal to be granted or revoked permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(DataLakePrincipal principal);

        /**
         * <p>
         * The Data Lake principal to be granted or revoked permissions.
         * </p>
         * This is a convenience that creates an instance of the {@link DataLakePrincipal.Builder} avoiding the need to
         * create one manually via {@link DataLakePrincipal#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataLakePrincipal.Builder#build()} is called immediately and its
         * result is passed to {@link #principal(DataLakePrincipal)}.
         * 
         * @param principal
         *        a consumer that will call methods on {@link DataLakePrincipal.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #principal(DataLakePrincipal)
         */
        default Builder principal(Consumer<DataLakePrincipal.Builder> principal) {
            return principal(DataLakePrincipal.builder().applyMutation(principal).build());
        }

        /**
         * <p>
         * The resource where permissions are to be granted or revoked.
         * </p>
         * 
         * @param resource
         *        The resource where permissions are to be granted or revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(Resource resource);

        /**
         * <p>
         * The resource where permissions are to be granted or revoked.
         * </p>
         * This is a convenience that creates an instance of the {@link Resource.Builder} avoiding the need to create
         * one manually via {@link Resource#builder()}.
         *
         * When the {@link Consumer} completes, {@link Resource.Builder#build()} is called immediately and its result is
         * passed to {@link #resource(Resource)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link Resource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(Resource)
         */
        default Builder resource(Consumer<Resource.Builder> resource) {
            return resource(Resource.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The permissions to be granted or revoked on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted or revoked on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(Collection<String> permissions);

        /**
         * <p>
         * The permissions to be granted or revoked on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted or revoked on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithStrings(String... permissions);

        /**
         * <p>
         * The permissions to be granted or revoked on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted or revoked on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<Permission> permissions);

        /**
         * <p>
         * The permissions to be granted or revoked on the resource.
         * </p>
         * 
         * @param permissions
         *        The permissions to be granted or revoked on the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Permission... permissions);

        /**
         * <p>
         * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption);

        /**
         * <p>
         * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOptionWithStrings(String... permissionsWithGrantOption);

        /**
         * <p>
         * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption);

        /**
         * <p>
         * Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * </p>
         * 
         * @param permissionsWithGrantOption
         *        Indicates whether to grant the ability to grant permissions (as a subset of permissions granted).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissionsWithGrantOption(Permission... permissionsWithGrantOption);

        /**
         * <p>
         * This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>.
         * Currently returns only as a RAM share resource ARN.
         * </p>
         * 
         * @param additionalDetails
         *        This attribute can be used to return any additional details of
         *        <code>PrincipalResourcePermissions</code>. Currently returns only as a RAM share resource ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalDetails(DetailsMap additionalDetails);

        /**
         * <p>
         * This attribute can be used to return any additional details of <code>PrincipalResourcePermissions</code>.
         * Currently returns only as a RAM share resource ARN.
         * </p>
         * This is a convenience that creates an instance of the {@link DetailsMap.Builder} avoiding the need to create
         * one manually via {@link DetailsMap#builder()}.
         *
         * When the {@link Consumer} completes, {@link DetailsMap.Builder#build()} is called immediately and its result
         * is passed to {@link #additionalDetails(DetailsMap)}.
         * 
         * @param additionalDetails
         *        a consumer that will call methods on {@link DetailsMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalDetails(DetailsMap)
         */
        default Builder additionalDetails(Consumer<DetailsMap.Builder> additionalDetails) {
            return additionalDetails(DetailsMap.builder().applyMutation(additionalDetails).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private DataLakePrincipal principal;

        private Resource resource;

        private List<String> permissions = DefaultSdkAutoConstructList.getInstance();

        private List<String> permissionsWithGrantOption = DefaultSdkAutoConstructList.getInstance();

        private DetailsMap additionalDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(PrincipalResourcePermissions model) {
            principal(model.principal);
            resource(model.resource);
            permissionsWithStrings(model.permissions);
            permissionsWithGrantOptionWithStrings(model.permissionsWithGrantOption);
            additionalDetails(model.additionalDetails);
        }

        public final DataLakePrincipal.Builder getPrincipal() {
            return principal != null ? principal.toBuilder() : null;
        }

        @Override
        public final Builder principal(DataLakePrincipal principal) {
            this.principal = principal;
            return this;
        }

        public final void setPrincipal(DataLakePrincipal.BuilderImpl principal) {
            this.principal = principal != null ? principal.build() : null;
        }

        public final Resource.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        @Override
        public final Builder resource(Resource resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(Resource.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        public final Collection<String> getPermissions() {
            return permissions;
        }

        @Override
        public final Builder permissionsWithStrings(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithStrings(String... permissions) {
            permissionsWithStrings(Arrays.asList(permissions));
            return this;
        }

        @Override
        public final Builder permissions(Collection<Permission> permissions) {
            this.permissions = PermissionListCopier.copyEnumToString(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Permission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        public final void setPermissions(Collection<String> permissions) {
            this.permissions = PermissionListCopier.copy(permissions);
        }

        public final Collection<String> getPermissionsWithGrantOption() {
            return permissionsWithGrantOption;
        }

        @Override
        public final Builder permissionsWithGrantOptionWithStrings(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOptionWithStrings(String... permissionsWithGrantOption) {
            permissionsWithGrantOptionWithStrings(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        @Override
        public final Builder permissionsWithGrantOption(Collection<Permission> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copyEnumToString(permissionsWithGrantOption);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissionsWithGrantOption(Permission... permissionsWithGrantOption) {
            permissionsWithGrantOption(Arrays.asList(permissionsWithGrantOption));
            return this;
        }

        public final void setPermissionsWithGrantOption(Collection<String> permissionsWithGrantOption) {
            this.permissionsWithGrantOption = PermissionListCopier.copy(permissionsWithGrantOption);
        }

        public final DetailsMap.Builder getAdditionalDetails() {
            return additionalDetails != null ? additionalDetails.toBuilder() : null;
        }

        @Override
        public final Builder additionalDetails(DetailsMap additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        public final void setAdditionalDetails(DetailsMap.BuilderImpl additionalDetails) {
            this.additionalDetails = additionalDetails != null ? additionalDetails.build() : null;
        }

        @Override
        public PrincipalResourcePermissions build() {
            return new PrincipalResourcePermissions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
