/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the output of an <code>UpdateMLModel</code> operation.
 * </p>
 * <p>
 * You can see the updated content by using the <code>GetMLModel</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateMlModelResponse extends MachineLearningResponse implements
        ToCopyableBuilder<UpdateMlModelResponse.Builder, UpdateMlModelResponse> {
    private static final SdkField<String> ML_MODEL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MLModelId").getter(getter(UpdateMlModelResponse::mlModelId)).setter(setter(Builder::mlModelId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MLModelId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ML_MODEL_ID_FIELD));

    private final String mlModelId;

    private UpdateMlModelResponse(BuilderImpl builder) {
        super(builder);
        this.mlModelId = builder.mlModelId;
    }

    /**
     * <p>
     * The ID assigned to the <code>MLModel</code> during creation. This value should be identical to the value of the
     * <code>MLModelID</code> in the request.
     * </p>
     * 
     * @return The ID assigned to the <code>MLModel</code> during creation. This value should be identical to the value
     *         of the <code>MLModelID</code> in the request.
     */
    public String mlModelId() {
        return mlModelId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(mlModelId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateMlModelResponse)) {
            return false;
        }
        UpdateMlModelResponse other = (UpdateMlModelResponse) obj;
        return Objects.equals(mlModelId(), other.mlModelId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateMlModelResponse").add("MLModelId", mlModelId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MLModelId":
            return Optional.ofNullable(clazz.cast(mlModelId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateMlModelResponse, T> g) {
        return obj -> g.apply((UpdateMlModelResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MachineLearningResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateMlModelResponse> {
        /**
         * <p>
         * The ID assigned to the <code>MLModel</code> during creation. This value should be identical to the value of
         * the <code>MLModelID</code> in the request.
         * </p>
         * 
         * @param mlModelId
         *        The ID assigned to the <code>MLModel</code> during creation. This value should be identical to the
         *        value of the <code>MLModelID</code> in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mlModelId(String mlModelId);
    }

    static final class BuilderImpl extends MachineLearningResponse.BuilderImpl implements Builder {
        private String mlModelId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateMlModelResponse model) {
            super(model);
            mlModelId(model.mlModelId);
        }

        public final String getMlModelId() {
            return mlModelId;
        }

        @Override
        public final Builder mlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
            return this;
        }

        public final void setMlModelId(String mlModelId) {
            this.mlModelId = mlModelId;
        }

        @Override
        public UpdateMlModelResponse build() {
            return new UpdateMlModelResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
