/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.machinelearning.waiters;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.machinelearning.MachineLearningClient;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeBatchPredictionsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeDataSourcesResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeEvaluationsResponse;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsRequest;
import software.amazon.awssdk.services.machinelearning.model.DescribeMlModelsResponse;
import software.amazon.awssdk.utils.SdkAutoCloseable;

/**
 * Waiter utility class that polls a resource until a desired state is reached or until it is determined that the
 * resource will never enter into the desired state. This can be created using the static {@link #builder()} method
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
public interface MachineLearningWaiter extends SdkAutoCloseable {
    /**
     * Polls {@link MachineLearningClient#describeBatchPredictions} API until the desired condition
     * {@code BatchPredictionAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeBatchPredictionsRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeBatchPredictionsResponse> waitUntilBatchPredictionAvailable(
            DescribeBatchPredictionsRequest describeBatchPredictionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link MachineLearningClient#describeBatchPredictions} API until the desired condition
     * {@code BatchPredictionAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeBatchPredictionsRequest#builder()}
     *
     * @param describeBatchPredictionsRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeBatchPredictionsResponse> waitUntilBatchPredictionAvailable(
            Consumer<DescribeBatchPredictionsRequest.Builder> describeBatchPredictionsRequest) {
        return waitUntilBatchPredictionAvailable(DescribeBatchPredictionsRequest.builder()
                .applyMutation(describeBatchPredictionsRequest).build());
    }

    /**
     * Polls {@link MachineLearningClient#describeBatchPredictions} API until the desired condition
     * {@code BatchPredictionAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state
     *
     * @param describeBatchPredictionsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeBatchPredictionsResponse> waitUntilBatchPredictionAvailable(
            DescribeBatchPredictionsRequest describeBatchPredictionsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link MachineLearningClient#describeBatchPredictions} API until the desired condition
     * {@code BatchPredictionAvailable} is met, or until it is determined that the resource will never enter into the
     * desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeBatchPredictionsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeBatchPredictionsResponse> waitUntilBatchPredictionAvailable(
            Consumer<DescribeBatchPredictionsRequest.Builder> describeBatchPredictionsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilBatchPredictionAvailable(
                DescribeBatchPredictionsRequest.builder().applyMutation(describeBatchPredictionsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link MachineLearningClient#describeDataSources} API until the desired condition
     * {@code DataSourceAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state
     *
     * @param describeDataSourcesRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeDataSourcesResponse> waitUntilDataSourceAvailable(
            DescribeDataSourcesRequest describeDataSourcesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link MachineLearningClient#describeDataSources} API until the desired condition
     * {@code DataSourceAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeDataSourcesRequest#builder()}
     *
     * @param describeDataSourcesRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeDataSourcesResponse> waitUntilDataSourceAvailable(
            Consumer<DescribeDataSourcesRequest.Builder> describeDataSourcesRequest) {
        return waitUntilDataSourceAvailable(DescribeDataSourcesRequest.builder().applyMutation(describeDataSourcesRequest)
                .build());
    }

    /**
     * Polls {@link MachineLearningClient#describeDataSources} API until the desired condition
     * {@code DataSourceAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state
     *
     * @param describeDataSourcesRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeDataSourcesResponse> waitUntilDataSourceAvailable(
            DescribeDataSourcesRequest describeDataSourcesRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link MachineLearningClient#describeDataSources} API until the desired condition
     * {@code DataSourceAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeDataSourcesRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeDataSourcesResponse> waitUntilDataSourceAvailable(
            Consumer<DescribeDataSourcesRequest.Builder> describeDataSourcesRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilDataSourceAvailable(DescribeDataSourcesRequest.builder().applyMutation(describeDataSourcesRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link MachineLearningClient#describeEvaluations} API until the desired condition
     * {@code EvaluationAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state
     *
     * @param describeEvaluationsRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeEvaluationsResponse> waitUntilEvaluationAvailable(
            DescribeEvaluationsRequest describeEvaluationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link MachineLearningClient#describeEvaluations} API until the desired condition
     * {@code EvaluationAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeEvaluationsRequest#builder()}
     *
     * @param describeEvaluationsRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeEvaluationsResponse> waitUntilEvaluationAvailable(
            Consumer<DescribeEvaluationsRequest.Builder> describeEvaluationsRequest) {
        return waitUntilEvaluationAvailable(DescribeEvaluationsRequest.builder().applyMutation(describeEvaluationsRequest)
                .build());
    }

    /**
     * Polls {@link MachineLearningClient#describeEvaluations} API until the desired condition
     * {@code EvaluationAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state
     *
     * @param describeEvaluationsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeEvaluationsResponse> waitUntilEvaluationAvailable(
            DescribeEvaluationsRequest describeEvaluationsRequest, WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link MachineLearningClient#describeEvaluations} API until the desired condition
     * {@code EvaluationAvailable} is met, or until it is determined that the resource will never enter into the desired
     * state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeEvaluationsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeEvaluationsResponse> waitUntilEvaluationAvailable(
            Consumer<DescribeEvaluationsRequest.Builder> describeEvaluationsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilEvaluationAvailable(DescribeEvaluationsRequest.builder().applyMutation(describeEvaluationsRequest)
                .build(), WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Polls {@link MachineLearningClient#describeMLModels} API until the desired condition {@code MLModelAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeMlModelsRequest
     *        the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeMlModelsResponse> waitUntilMLModelAvailable(DescribeMlModelsRequest describeMlModelsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link MachineLearningClient#describeMLModels} API until the desired condition {@code MLModelAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder without the need to create one manually
     * using {@link DescribeMlModelsRequest#builder()}
     *
     * @param describeMlModelsRequest
     *        The consumer that will configure the request to be used for polling
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeMlModelsResponse> waitUntilMLModelAvailable(
            Consumer<DescribeMlModelsRequest.Builder> describeMlModelsRequest) {
        return waitUntilMLModelAvailable(DescribeMlModelsRequest.builder().applyMutation(describeMlModelsRequest).build());
    }

    /**
     * Polls {@link MachineLearningClient#describeMLModels} API until the desired condition {@code MLModelAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state
     *
     * @param describeMlModelsRequest
     *        The request to be used for polling
     * @param overrideConfig
     *        Per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeMlModelsResponse> waitUntilMLModelAvailable(DescribeMlModelsRequest describeMlModelsRequest,
            WaiterOverrideConfiguration overrideConfig) {
        throw new UnsupportedOperationException();
    }

    /**
     * Polls {@link MachineLearningClient#describeMLModels} API until the desired condition {@code MLModelAvailable} is
     * met, or until it is determined that the resource will never enter into the desired state.
     * <p>
     * This is a convenience method to create an instance of the request builder and instance of the override config
     * builder
     *
     * @param describeMlModelsRequest
     *        The consumer that will configure the request to be used for polling
     * @param overrideConfig
     *        The consumer that will configure the per request override configuration for waiters
     * @return WaiterResponse containing either a response or an exception that has matched with the waiter success
     *         condition
     */
    default WaiterResponse<DescribeMlModelsResponse> waitUntilMLModelAvailable(
            Consumer<DescribeMlModelsRequest.Builder> describeMlModelsRequest,
            Consumer<WaiterOverrideConfiguration.Builder> overrideConfig) {
        return waitUntilMLModelAvailable(DescribeMlModelsRequest.builder().applyMutation(describeMlModelsRequest).build(),
                WaiterOverrideConfiguration.builder().applyMutation(overrideConfig).build());
    }

    /**
     * Create a builder that can be used to configure and create a {@link MachineLearningWaiter}.
     *
     * @return a builder
     */
    static Builder builder() {
        return DefaultMachineLearningWaiter.builder();
    }

    /**
     * Create an instance of {@link MachineLearningWaiter} with the default configuration.
     * <p>
     * <b>A default {@link MachineLearningClient} will be created to poll resources. It is recommended to share a single
     * instance of the waiter created via this method. If it is not desirable to share a waiter instance, invoke
     * {@link #close()} to release the resources once the waiter is not needed.</b>
     *
     * @return an instance of {@link MachineLearningWaiter}
     */
    static MachineLearningWaiter create() {
        return DefaultMachineLearningWaiter.builder().build();
    }

    interface Builder {
        /**
         * Defines overrides to the default SDK waiter configuration that should be used for waiters created from this
         * builder
         *
         * @param overrideConfiguration
         *        the override configuration to set
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration);

        /**
         * This is a convenient method to pass the override configuration without the need to create an instance
         * manually via {@link WaiterOverrideConfiguration#builder()}
         *
         * @param overrideConfiguration
         *        The consumer that will configure the overrideConfiguration
         * @return a reference to this object so that method calls can be chained together.
         * @see #overrideConfiguration(WaiterOverrideConfiguration)
         */
        default Builder overrideConfiguration(Consumer<WaiterOverrideConfiguration.Builder> overrideConfiguration) {
            WaiterOverrideConfiguration.Builder builder = WaiterOverrideConfiguration.builder();
            overrideConfiguration.accept(builder);
            return overrideConfiguration(builder.build());
        }

        /**
         * Sets a custom {@link MachineLearningClient} that will be used to poll the resource
         * <p>
         * This SDK client must be closed by the caller when it is ready to be disposed. The SDK will not close the
         * client when the waiter is closed
         *
         * @param client
         *        the client to send the request
         * @return a reference to this object so that method calls can be chained together.
         */
        Builder client(MachineLearningClient client);

        /**
         * Builds an instance of {@link MachineLearningWaiter} based on the configurations supplied to this builder
         *
         * @return An initialized {@link MachineLearningWaiter}
         */
        MachineLearningWaiter build();
    }
}
