/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.macie.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.macie.model.MacieRequest;
import software.amazon.awssdk.services.macie.model.S3ResourceClassification;
import software.amazon.awssdk.services.macie.model.S3ResourcesClassificationCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssociateS3ResourcesRequest
extends MacieRequest
implements ToCopyableBuilder<Builder, AssociateS3ResourcesRequest> {
    private static final SdkField<String> MEMBER_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("memberAccountId").getter(AssociateS3ResourcesRequest.getter(AssociateS3ResourcesRequest::memberAccountId)).setter(AssociateS3ResourcesRequest.setter(Builder::memberAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memberAccountId").build()}).build();
    private static final SdkField<List<S3ResourceClassification>> S3_RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("s3Resources").getter(AssociateS3ResourcesRequest.getter(AssociateS3ResourcesRequest::s3Resources)).setter(AssociateS3ResourcesRequest.setter(Builder::s3Resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(S3ResourceClassification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBER_ACCOUNT_ID_FIELD, S3_RESOURCES_FIELD));
    private final String memberAccountId;
    private final List<S3ResourceClassification> s3Resources;

    private AssociateS3ResourcesRequest(BuilderImpl builder) {
        super(builder);
        this.memberAccountId = builder.memberAccountId;
        this.s3Resources = builder.s3Resources;
    }

    public String memberAccountId() {
        return this.memberAccountId;
    }

    public boolean hasS3Resources() {
        return this.s3Resources != null && !(this.s3Resources instanceof SdkAutoConstructList);
    }

    public List<S3ResourceClassification> s3Resources() {
        return this.s3Resources;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.memberAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Resources());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateS3ResourcesRequest)) {
            return false;
        }
        AssociateS3ResourcesRequest other = (AssociateS3ResourcesRequest)((Object)obj);
        return Objects.equals(this.memberAccountId(), other.memberAccountId()) && Objects.equals(this.s3Resources(), other.s3Resources());
    }

    public String toString() {
        return ToString.builder((String)"AssociateS3ResourcesRequest").add("MemberAccountId", (Object)this.memberAccountId()).add("S3Resources", this.s3Resources()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "memberAccountId": {
                return Optional.ofNullable(clazz.cast(this.memberAccountId()));
            }
            case "s3Resources": {
                return Optional.ofNullable(clazz.cast(this.s3Resources()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AssociateS3ResourcesRequest, T> g) {
        return obj -> g.apply((AssociateS3ResourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MacieRequest.BuilderImpl
    implements Builder {
        private String memberAccountId;
        private List<S3ResourceClassification> s3Resources = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateS3ResourcesRequest model) {
            super(model);
            this.memberAccountId(model.memberAccountId);
            this.s3Resources(model.s3Resources);
        }

        public final String getMemberAccountId() {
            return this.memberAccountId;
        }

        @Override
        public final Builder memberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
            return this;
        }

        public final void setMemberAccountId(String memberAccountId) {
            this.memberAccountId = memberAccountId;
        }

        public final Collection<S3ResourceClassification.Builder> getS3Resources() {
            return this.s3Resources != null ? (Collection)this.s3Resources.stream().map(S3ResourceClassification::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder s3Resources(Collection<S3ResourceClassification> s3Resources) {
            this.s3Resources = S3ResourcesClassificationCopier.copy(s3Resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(S3ResourceClassification ... s3Resources) {
            this.s3Resources(Arrays.asList(s3Resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder s3Resources(Consumer<S3ResourceClassification.Builder> ... s3Resources) {
            this.s3Resources(Stream.of(s3Resources).map(c -> (S3ResourceClassification)((S3ResourceClassification.Builder)S3ResourceClassification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setS3Resources(Collection<S3ResourceClassification.BuilderImpl> s3Resources) {
            this.s3Resources = S3ResourcesClassificationCopier.copyFromBuilder(s3Resources);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateS3ResourcesRequest build() {
            return new AssociateS3ResourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MacieRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AssociateS3ResourcesRequest> {
        public Builder memberAccountId(String var1);

        public Builder s3Resources(Collection<S3ResourceClassification> var1);

        public Builder s3Resources(S3ResourceClassification ... var1);

        public Builder s3Resources(Consumer<S3ResourceClassification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

