/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mediapackagevod.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPackagingGroupsResponse extends MediaPackageVodResponse implements
        ToCopyableBuilder<ListPackagingGroupsResponse.Builder, ListPackagingGroupsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPackagingGroupsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<PackagingGroup>> PACKAGING_GROUPS_FIELD = SdkField
            .<List<PackagingGroup>> builder(MarshallingType.LIST)
            .memberName("PackagingGroups")
            .getter(getter(ListPackagingGroupsResponse::packagingGroups))
            .setter(setter(Builder::packagingGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("packagingGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PackagingGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(PackagingGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            PACKAGING_GROUPS_FIELD));

    private final String nextToken;

    private final List<PackagingGroup> packagingGroups;

    private ListPackagingGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.packagingGroups = builder.packagingGroups;
    }

    /**
     * A token that can be used to resume pagination from the end of the collection.
     * 
     * @return A token that can be used to resume pagination from the end of the collection.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the PackagingGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPackagingGroups() {
        return packagingGroups != null && !(packagingGroups instanceof SdkAutoConstructList);
    }

    /**
     * A list of MediaPackage VOD PackagingGroup resources.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPackagingGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of MediaPackage VOD PackagingGroup resources.
     */
    public List<PackagingGroup> packagingGroups() {
        return packagingGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(packagingGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPackagingGroupsResponse)) {
            return false;
        }
        ListPackagingGroupsResponse other = (ListPackagingGroupsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(packagingGroups(), other.packagingGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListPackagingGroupsResponse").add("NextToken", nextToken())
                .add("PackagingGroups", packagingGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "PackagingGroups":
            return Optional.ofNullable(clazz.cast(packagingGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPackagingGroupsResponse, T> g) {
        return obj -> g.apply((ListPackagingGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MediaPackageVodResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListPackagingGroupsResponse> {
        /**
         * A token that can be used to resume pagination from the end of the collection.
         * 
         * @param nextToken
         *        A token that can be used to resume pagination from the end of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * A list of MediaPackage VOD PackagingGroup resources.
         * 
         * @param packagingGroups
         *        A list of MediaPackage VOD PackagingGroup resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagingGroups(Collection<PackagingGroup> packagingGroups);

        /**
         * A list of MediaPackage VOD PackagingGroup resources.
         * 
         * @param packagingGroups
         *        A list of MediaPackage VOD PackagingGroup resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packagingGroups(PackagingGroup... packagingGroups);

        /**
         * A list of MediaPackage VOD PackagingGroup resources. This is a convenience that creates an instance of the
         * {@link List<PackagingGroup>.Builder} avoiding the need to create one manually via {@link List
         * <PackagingGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<PackagingGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #packagingGroups(List<PackagingGroup>)}.
         * 
         * @param packagingGroups
         *        a consumer that will call methods on {@link List<PackagingGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packagingGroups(List<PackagingGroup>)
         */
        Builder packagingGroups(Consumer<PackagingGroup.Builder>... packagingGroups);
    }

    static final class BuilderImpl extends MediaPackageVodResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<PackagingGroup> packagingGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListPackagingGroupsResponse model) {
            super(model);
            nextToken(model.nextToken);
            packagingGroups(model.packagingGroups);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<PackagingGroup.Builder> getPackagingGroups() {
            return packagingGroups != null ? packagingGroups.stream().map(PackagingGroup::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder packagingGroups(Collection<PackagingGroup> packagingGroups) {
            this.packagingGroups = ___listOfPackagingGroupCopier.copy(packagingGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packagingGroups(PackagingGroup... packagingGroups) {
            packagingGroups(Arrays.asList(packagingGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packagingGroups(Consumer<PackagingGroup.Builder>... packagingGroups) {
            packagingGroups(Stream.of(packagingGroups).map(c -> PackagingGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPackagingGroups(Collection<PackagingGroup.BuilderImpl> packagingGroups) {
            this.packagingGroups = ___listOfPackagingGroupCopier.copyFromBuilder(packagingGroups);
        }

        @Override
        public ListPackagingGroupsResponse build() {
            return new ListPackagingGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
