/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListCreatedArtifactsResponse extends MigrationHubResponse implements
        ToCopyableBuilder<ListCreatedArtifactsResponse.Builder, ListCreatedArtifactsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListCreatedArtifactsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<CreatedArtifact>> CREATED_ARTIFACT_LIST_FIELD = SdkField
            .<List<CreatedArtifact>> builder(MarshallingType.LIST)
            .memberName("CreatedArtifactList")
            .getter(getter(ListCreatedArtifactsResponse::createdArtifactList))
            .setter(setter(Builder::createdArtifactList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedArtifactList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CreatedArtifact> builder(MarshallingType.SDK_POJO)
                                            .constructor(CreatedArtifact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            CREATED_ARTIFACT_LIST_FIELD));

    private final String nextToken;

    private final List<CreatedArtifact> createdArtifactList;

    private ListCreatedArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.createdArtifactList = builder.createdArtifactList;
    }

    /**
     * <p>
     * If there are more created artifacts than the max result, return the next token to be passed to the next call as a
     * bookmark of where to start from.
     * </p>
     * 
     * @return If there are more created artifacts than the max result, return the next token to be passed to the next
     *         call as a bookmark of where to start from.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the CreatedArtifactList property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasCreatedArtifactList() {
        return createdArtifactList != null && !(createdArtifactList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of created artifacts up to the maximum number of results specified in the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCreatedArtifactList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of created artifacts up to the maximum number of results specified in the request.
     */
    public List<CreatedArtifact> createdArtifactList() {
        return createdArtifactList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(createdArtifactList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCreatedArtifactsResponse)) {
            return false;
        }
        ListCreatedArtifactsResponse other = (ListCreatedArtifactsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(createdArtifactList(), other.createdArtifactList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListCreatedArtifactsResponse").add("NextToken", nextToken())
                .add("CreatedArtifactList", createdArtifactList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "CreatedArtifactList":
            return Optional.ofNullable(clazz.cast(createdArtifactList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListCreatedArtifactsResponse, T> g) {
        return obj -> g.apply((ListCreatedArtifactsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends MigrationHubResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListCreatedArtifactsResponse> {
        /**
         * <p>
         * If there are more created artifacts than the max result, return the next token to be passed to the next call
         * as a bookmark of where to start from.
         * </p>
         * 
         * @param nextToken
         *        If there are more created artifacts than the max result, return the next token to be passed to the
         *        next call as a bookmark of where to start from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * List of created artifacts up to the maximum number of results specified in the request.
         * </p>
         * 
         * @param createdArtifactList
         *        List of created artifacts up to the maximum number of results specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdArtifactList(Collection<CreatedArtifact> createdArtifactList);

        /**
         * <p>
         * List of created artifacts up to the maximum number of results specified in the request.
         * </p>
         * 
         * @param createdArtifactList
         *        List of created artifacts up to the maximum number of results specified in the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdArtifactList(CreatedArtifact... createdArtifactList);

        /**
         * <p>
         * List of created artifacts up to the maximum number of results specified in the request.
         * </p>
         * This is a convenience that creates an instance of the {@link List<CreatedArtifact>.Builder} avoiding the need
         * to create one manually via {@link List<CreatedArtifact>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<CreatedArtifact>.Builder#build()} is called immediately and
         * its result is passed to {@link #createdArtifactList(List<CreatedArtifact>)}.
         * 
         * @param createdArtifactList
         *        a consumer that will call methods on {@link List<CreatedArtifact>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createdArtifactList(List<CreatedArtifact>)
         */
        Builder createdArtifactList(Consumer<CreatedArtifact.Builder>... createdArtifactList);
    }

    static final class BuilderImpl extends MigrationHubResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<CreatedArtifact> createdArtifactList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListCreatedArtifactsResponse model) {
            super(model);
            nextToken(model.nextToken);
            createdArtifactList(model.createdArtifactList);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CreatedArtifact.Builder> getCreatedArtifactList() {
            return createdArtifactList != null ? createdArtifactList.stream().map(CreatedArtifact::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createdArtifactList(Collection<CreatedArtifact> createdArtifactList) {
            this.createdArtifactList = CreatedArtifactListCopier.copy(createdArtifactList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdArtifactList(CreatedArtifact... createdArtifactList) {
            createdArtifactList(Arrays.asList(createdArtifactList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdArtifactList(Consumer<CreatedArtifact.Builder>... createdArtifactList) {
            createdArtifactList(Stream.of(createdArtifactList).map(c -> CreatedArtifact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setCreatedArtifactList(Collection<CreatedArtifact.BuilderImpl> createdArtifactList) {
            this.createdArtifactList = CreatedArtifactListCopier.copyFromBuilder(createdArtifactList);
        }

        @Override
        public ListCreatedArtifactsResponse build() {
            return new ListCreatedArtifactsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
