/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.migrationhub.model;

import static java.util.stream.Collectors.toList;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class MigrationTaskSummaryListCopier {
    static List<MigrationTaskSummary> copy(Collection<MigrationTaskSummary> migrationTaskSummaryListParam) {
        if (migrationTaskSummaryListParam == null || migrationTaskSummaryListParam instanceof SdkAutoConstructList) {
            return DefaultSdkAutoConstructList.getInstance();
        }
        List<MigrationTaskSummary> migrationTaskSummaryListParamCopy = new ArrayList<>(migrationTaskSummaryListParam);
        return Collections.unmodifiableList(migrationTaskSummaryListParamCopy);
    }

    static List<MigrationTaskSummary> copyFromBuilder(
            Collection<? extends MigrationTaskSummary.Builder> migrationTaskSummaryListParam) {
        if (migrationTaskSummaryListParam == null) {
            return null;
        }
        return copy(migrationTaskSummaryListParam.stream().map(MigrationTaskSummary.Builder::build).collect(toList()));
    }
}
