/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration setting for the log types to be enabled for export to CloudWatch Logs for a specific DB instance or
 * DB cluster.
 * </p>
 * <p>
 * The <code>EnableLogTypes</code> and <code>DisableLogTypes</code> arrays determine which logs will be exported (or not
 * exported) to CloudWatch Logs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudwatchLogsExportConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudwatchLogsExportConfiguration.Builder, CloudwatchLogsExportConfiguration> {
    private static final SdkField<List<String>> ENABLE_LOG_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EnableLogTypes")
            .getter(getter(CloudwatchLogsExportConfiguration::enableLogTypes))
            .setter(setter(Builder::enableLogTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableLogTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> DISABLE_LOG_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("DisableLogTypes")
            .getter(getter(CloudwatchLogsExportConfiguration::disableLogTypes))
            .setter(setter(Builder::disableLogTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisableLogTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_LOG_TYPES_FIELD,
            DISABLE_LOG_TYPES_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> enableLogTypes;

    private final List<String> disableLogTypes;

    private CloudwatchLogsExportConfiguration(BuilderImpl builder) {
        this.enableLogTypes = builder.enableLogTypes;
        this.disableLogTypes = builder.disableLogTypes;
    }

    /**
     * Returns true if the EnableLogTypes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasEnableLogTypes() {
        return enableLogTypes != null && !(enableLogTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of log types to enable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasEnableLogTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of log types to enable.
     */
    public List<String> enableLogTypes() {
        return enableLogTypes;
    }

    /**
     * Returns true if the DisableLogTypes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDisableLogTypes() {
        return disableLogTypes != null && !(disableLogTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of log types to disable.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDisableLogTypes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of log types to disable.
     */
    public List<String> disableLogTypes() {
        return disableLogTypes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableLogTypes());
        hashCode = 31 * hashCode + Objects.hashCode(disableLogTypes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudwatchLogsExportConfiguration)) {
            return false;
        }
        CloudwatchLogsExportConfiguration other = (CloudwatchLogsExportConfiguration) obj;
        return Objects.equals(enableLogTypes(), other.enableLogTypes())
                && Objects.equals(disableLogTypes(), other.disableLogTypes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CloudwatchLogsExportConfiguration").add("EnableLogTypes", enableLogTypes())
                .add("DisableLogTypes", disableLogTypes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableLogTypes":
            return Optional.ofNullable(clazz.cast(enableLogTypes()));
        case "DisableLogTypes":
            return Optional.ofNullable(clazz.cast(disableLogTypes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CloudwatchLogsExportConfiguration, T> g) {
        return obj -> g.apply((CloudwatchLogsExportConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudwatchLogsExportConfiguration> {
        /**
         * <p>
         * The list of log types to enable.
         * </p>
         * 
         * @param enableLogTypes
         *        The list of log types to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableLogTypes(Collection<String> enableLogTypes);

        /**
         * <p>
         * The list of log types to enable.
         * </p>
         * 
         * @param enableLogTypes
         *        The list of log types to enable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableLogTypes(String... enableLogTypes);

        /**
         * <p>
         * The list of log types to disable.
         * </p>
         * 
         * @param disableLogTypes
         *        The list of log types to disable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableLogTypes(Collection<String> disableLogTypes);

        /**
         * <p>
         * The list of log types to disable.
         * </p>
         * 
         * @param disableLogTypes
         *        The list of log types to disable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableLogTypes(String... disableLogTypes);
    }

    static final class BuilderImpl implements Builder {
        private List<String> enableLogTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> disableLogTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CloudwatchLogsExportConfiguration model) {
            enableLogTypes(model.enableLogTypes);
            disableLogTypes(model.disableLogTypes);
        }

        public final Collection<String> getEnableLogTypes() {
            return enableLogTypes;
        }

        @Override
        public final Builder enableLogTypes(Collection<String> enableLogTypes) {
            this.enableLogTypes = LogTypeListCopier.copy(enableLogTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enableLogTypes(String... enableLogTypes) {
            enableLogTypes(Arrays.asList(enableLogTypes));
            return this;
        }

        public final void setEnableLogTypes(Collection<String> enableLogTypes) {
            this.enableLogTypes = LogTypeListCopier.copy(enableLogTypes);
        }

        public final Collection<String> getDisableLogTypes() {
            return disableLogTypes;
        }

        @Override
        public final Builder disableLogTypes(Collection<String> disableLogTypes) {
            this.disableLogTypes = LogTypeListCopier.copy(disableLogTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder disableLogTypes(String... disableLogTypes) {
            disableLogTypes(Arrays.asList(disableLogTypes));
            return this;
        }

        public final void setDisableLogTypes(Collection<String> disableLogTypes) {
            this.disableLogTypes = LogTypeListCopier.copy(disableLogTypes);
        }

        @Override
        public CloudwatchLogsExportConfiguration build() {
            return new CloudwatchLogsExportConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
