/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.neptune.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDbParameterGroupsResponse extends NeptuneResponse implements
        ToCopyableBuilder<DescribeDbParameterGroupsResponse.Builder, DescribeDbParameterGroupsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeDbParameterGroupsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<DBParameterGroup>> DB_PARAMETER_GROUPS_FIELD = SdkField
            .<List<DBParameterGroup>> builder(MarshallingType.LIST)
            .memberName("DBParameterGroups")
            .getter(getter(DescribeDbParameterGroupsResponse::dbParameterGroups))
            .setter(setter(Builder::dbParameterGroups))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBParameterGroups").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DBParameterGroup")
                            .memberFieldInfo(
                                    SdkField.<DBParameterGroup> builder(MarshallingType.SDK_POJO)
                                            .constructor(DBParameterGroup::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DBParameterGroup").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            DB_PARAMETER_GROUPS_FIELD));

    private final String marker;

    private final List<DBParameterGroup> dbParameterGroups;

    private DescribeDbParameterGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.dbParameterGroups = builder.dbParameterGroups;
    }

    /**
     * <p>
     * An optional pagination token provided by a previous request. If this parameter is specified, the response
     * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     * </p>
     * 
     * @return An optional pagination token provided by a previous request. If this parameter is specified, the response
     *         includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the DBParameterGroups property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasDbParameterGroups() {
        return dbParameterGroups != null && !(dbParameterGroups instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of <a>DBParameterGroup</a> instances.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDbParameterGroups()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of <a>DBParameterGroup</a> instances.
     */
    public List<DBParameterGroup> dbParameterGroups() {
        return dbParameterGroups;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(dbParameterGroups());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDbParameterGroupsResponse)) {
            return false;
        }
        DescribeDbParameterGroupsResponse other = (DescribeDbParameterGroupsResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(dbParameterGroups(), other.dbParameterGroups());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeDbParameterGroupsResponse").add("Marker", marker())
                .add("DBParameterGroups", dbParameterGroups()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "DBParameterGroups":
            return Optional.ofNullable(clazz.cast(dbParameterGroups()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDbParameterGroupsResponse, T> g) {
        return obj -> g.apply((DescribeDbParameterGroupsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends NeptuneResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDbParameterGroupsResponse> {
        /**
         * <p>
         * An optional pagination token provided by a previous request. If this parameter is specified, the response
         * includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>.
         * </p>
         * 
         * @param marker
         *        An optional pagination token provided by a previous request. If this parameter is specified, the
         *        response includes only records beyond the marker, up to the value specified by <code>MaxRecords</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A list of <a>DBParameterGroup</a> instances.
         * </p>
         * 
         * @param dbParameterGroups
         *        A list of <a>DBParameterGroup</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroups(Collection<DBParameterGroup> dbParameterGroups);

        /**
         * <p>
         * A list of <a>DBParameterGroup</a> instances.
         * </p>
         * 
         * @param dbParameterGroups
         *        A list of <a>DBParameterGroup</a> instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dbParameterGroups(DBParameterGroup... dbParameterGroups);

        /**
         * <p>
         * A list of <a>DBParameterGroup</a> instances.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DBParameterGroup>.Builder} avoiding the
         * need to create one manually via {@link List<DBParameterGroup>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DBParameterGroup>.Builder#build()} is called immediately and
         * its result is passed to {@link #dbParameterGroups(List<DBParameterGroup>)}.
         * 
         * @param dbParameterGroups
         *        a consumer that will call methods on {@link List<DBParameterGroup>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dbParameterGroups(List<DBParameterGroup>)
         */
        Builder dbParameterGroups(Consumer<DBParameterGroup.Builder>... dbParameterGroups);
    }

    static final class BuilderImpl extends NeptuneResponse.BuilderImpl implements Builder {
        private String marker;

        private List<DBParameterGroup> dbParameterGroups = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDbParameterGroupsResponse model) {
            super(model);
            marker(model.marker);
            dbParameterGroups(model.dbParameterGroups);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<DBParameterGroup.Builder> getDbParameterGroups() {
            return dbParameterGroups != null ? dbParameterGroups.stream().map(DBParameterGroup::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dbParameterGroups(Collection<DBParameterGroup> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupListCopier.copy(dbParameterGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(DBParameterGroup... dbParameterGroups) {
            dbParameterGroups(Arrays.asList(dbParameterGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dbParameterGroups(Consumer<DBParameterGroup.Builder>... dbParameterGroups) {
            dbParameterGroups(Stream.of(dbParameterGroups).map(c -> DBParameterGroup.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setDbParameterGroups(Collection<DBParameterGroup.BuilderImpl> dbParameterGroups) {
            this.dbParameterGroups = DBParameterGroupListCopier.copyFromBuilder(dbParameterGroups);
        }

        @Override
        public DescribeDbParameterGroupsResponse build() {
            return new DescribeDbParameterGroupsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
