/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpointemail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Content
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Content> {
    private static final SdkField<String> DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Data").getter(Content.getter(Content::data)).setter(Content.setter(Builder::data)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()}).build();
    private static final SdkField<String> CHARSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Charset").getter(Content.getter(Content::charset)).setter(Content.setter(Builder::charset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Charset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_FIELD, CHARSET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String data;
    private final String charset;

    private Content(BuilderImpl builder) {
        this.data = builder.data;
        this.charset = builder.charset;
    }

    public String data() {
        return this.data;
    }

    public String charset() {
        return this.charset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.data());
        hashCode = 31 * hashCode + Objects.hashCode(this.charset());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Content)) {
            return false;
        }
        Content other = (Content)obj;
        return Objects.equals(this.data(), other.data()) && Objects.equals(this.charset(), other.charset());
    }

    public String toString() {
        return ToString.builder((String)"Content").add("Data", (Object)this.data()).add("Charset", (Object)this.charset()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Data": {
                return Optional.ofNullable(clazz.cast(this.data()));
            }
            case "Charset": {
                return Optional.ofNullable(clazz.cast(this.charset()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Content, T> g) {
        return obj -> g.apply((Content)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String data;
        private String charset;

        private BuilderImpl() {
        }

        private BuilderImpl(Content model) {
            this.data(model.data);
            this.charset(model.charset);
        }

        public final String getData() {
            return this.data;
        }

        @Override
        public final Builder data(String data) {
            this.data = data;
            return this;
        }

        public final void setData(String data) {
            this.data = data;
        }

        public final String getCharset() {
            return this.charset;
        }

        @Override
        public final Builder charset(String charset) {
            this.charset = charset;
            return this;
        }

        public final void setCharset(String charset) {
            this.charset = charset;
        }

        public Content build() {
            return new Content(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Content> {
        public Builder data(String var1);

        public Builder charset(String var1);
    }
}

