/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.transfer.s3.internal.model;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.transfer.s3.model.CompletedUpload;
import software.amazon.awssdk.transfer.s3.model.Upload;
import software.amazon.awssdk.transfer.s3.progress.TransferProgress;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public final class DefaultUpload
implements Upload {
    private final CompletableFuture<CompletedUpload> completionFuture;
    private final TransferProgress progress;

    public DefaultUpload(CompletableFuture<CompletedUpload> completionFuture, TransferProgress progress) {
        this.completionFuture = (CompletableFuture)Validate.paramNotNull(completionFuture, (String)"completionFuture");
        this.progress = (TransferProgress)Validate.paramNotNull((Object)progress, (String)"progress");
    }

    @Override
    public CompletableFuture<CompletedUpload> completionFuture() {
        return this.completionFuture;
    }

    @Override
    public TransferProgress progress() {
        return this.progress;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultUpload that = (DefaultUpload)o;
        if (!Objects.equals(this.completionFuture, that.completionFuture)) {
            return false;
        }
        return Objects.equals(this.progress, that.progress);
    }

    public int hashCode() {
        int result = this.completionFuture != null ? this.completionFuture.hashCode() : 0;
        result = 31 * result + (this.progress != null ? this.progress.hashCode() : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"DefaultUpload").add("completionFuture", this.completionFuture).add("progress", (Object)this.progress).build();
    }
}

