/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.UserProfileStatus;
import software.amazon.awssdk.services.sagemaker.model.UserSettings;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeUserProfileResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeUserProfileResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::domainId)).setter(DescribeUserProfileResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> USER_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserProfileArn").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::userProfileArn)).setter(DescribeUserProfileResponse.setter(Builder::userProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileArn").build()}).build();
    private static final SdkField<String> USER_PROFILE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UserProfileName").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::userProfileName)).setter(DescribeUserProfileResponse.setter(Builder::userProfileName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserProfileName").build()}).build();
    private static final SdkField<String> HOME_EFS_FILE_SYSTEM_UID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HomeEfsFileSystemUid").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::homeEfsFileSystemUid)).setter(DescribeUserProfileResponse.setter(Builder::homeEfsFileSystemUid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HomeEfsFileSystemUid").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::statusAsString)).setter(DescribeUserProfileResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::lastModifiedTime)).setter(DescribeUserProfileResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::creationTime)).setter(DescribeUserProfileResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::failureReason)).setter(DescribeUserProfileResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> SINGLE_SIGN_ON_USER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SingleSignOnUserIdentifier").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::singleSignOnUserIdentifier)).setter(DescribeUserProfileResponse.setter(Builder::singleSignOnUserIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnUserIdentifier").build()}).build();
    private static final SdkField<String> SINGLE_SIGN_ON_USER_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SingleSignOnUserValue").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::singleSignOnUserValue)).setter(DescribeUserProfileResponse.setter(Builder::singleSignOnUserValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleSignOnUserValue").build()}).build();
    private static final SdkField<UserSettings> USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UserSettings").getter(DescribeUserProfileResponse.getter(DescribeUserProfileResponse::userSettings)).setter(DescribeUserProfileResponse.setter(Builder::userSettings)).constructor(UserSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, USER_PROFILE_ARN_FIELD, USER_PROFILE_NAME_FIELD, HOME_EFS_FILE_SYSTEM_UID_FIELD, STATUS_FIELD, LAST_MODIFIED_TIME_FIELD, CREATION_TIME_FIELD, FAILURE_REASON_FIELD, SINGLE_SIGN_ON_USER_IDENTIFIER_FIELD, SINGLE_SIGN_ON_USER_VALUE_FIELD, USER_SETTINGS_FIELD));
    private final String domainId;
    private final String userProfileArn;
    private final String userProfileName;
    private final String homeEfsFileSystemUid;
    private final String status;
    private final Instant lastModifiedTime;
    private final Instant creationTime;
    private final String failureReason;
    private final String singleSignOnUserIdentifier;
    private final String singleSignOnUserValue;
    private final UserSettings userSettings;

    private DescribeUserProfileResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.userProfileArn = builder.userProfileArn;
        this.userProfileName = builder.userProfileName;
        this.homeEfsFileSystemUid = builder.homeEfsFileSystemUid;
        this.status = builder.status;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.creationTime = builder.creationTime;
        this.failureReason = builder.failureReason;
        this.singleSignOnUserIdentifier = builder.singleSignOnUserIdentifier;
        this.singleSignOnUserValue = builder.singleSignOnUserValue;
        this.userSettings = builder.userSettings;
    }

    public String domainId() {
        return this.domainId;
    }

    public String userProfileArn() {
        return this.userProfileArn;
    }

    public String userProfileName() {
        return this.userProfileName;
    }

    public String homeEfsFileSystemUid() {
        return this.homeEfsFileSystemUid;
    }

    public UserProfileStatus status() {
        return UserProfileStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public String singleSignOnUserIdentifier() {
        return this.singleSignOnUserIdentifier;
    }

    public String singleSignOnUserValue() {
        return this.singleSignOnUserValue;
    }

    public UserSettings userSettings() {
        return this.userSettings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.userProfileName());
        hashCode = 31 * hashCode + Objects.hashCode(this.homeEfsFileSystemUid());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOnUserIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.singleSignOnUserValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSettings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserProfileResponse)) {
            return false;
        }
        DescribeUserProfileResponse other = (DescribeUserProfileResponse)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.userProfileArn(), other.userProfileArn()) && Objects.equals(this.userProfileName(), other.userProfileName()) && Objects.equals(this.homeEfsFileSystemUid(), other.homeEfsFileSystemUid()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.singleSignOnUserIdentifier(), other.singleSignOnUserIdentifier()) && Objects.equals(this.singleSignOnUserValue(), other.singleSignOnUserValue()) && Objects.equals(this.userSettings(), other.userSettings());
    }

    public String toString() {
        return ToString.builder((String)"DescribeUserProfileResponse").add("DomainId", (Object)this.domainId()).add("UserProfileArn", (Object)this.userProfileArn()).add("UserProfileName", (Object)this.userProfileName()).add("HomeEfsFileSystemUid", (Object)this.homeEfsFileSystemUid()).add("Status", (Object)this.statusAsString()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("CreationTime", (Object)this.creationTime()).add("FailureReason", (Object)this.failureReason()).add("SingleSignOnUserIdentifier", (Object)this.singleSignOnUserIdentifier()).add("SingleSignOnUserValue", (Object)this.singleSignOnUserValue()).add("UserSettings", (Object)this.userSettings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "UserProfileArn": {
                return Optional.ofNullable(clazz.cast(this.userProfileArn()));
            }
            case "UserProfileName": {
                return Optional.ofNullable(clazz.cast(this.userProfileName()));
            }
            case "HomeEfsFileSystemUid": {
                return Optional.ofNullable(clazz.cast(this.homeEfsFileSystemUid()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "SingleSignOnUserIdentifier": {
                return Optional.ofNullable(clazz.cast(this.singleSignOnUserIdentifier()));
            }
            case "SingleSignOnUserValue": {
                return Optional.ofNullable(clazz.cast(this.singleSignOnUserValue()));
            }
            case "UserSettings": {
                return Optional.ofNullable(clazz.cast(this.userSettings()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserProfileResponse, T> g) {
        return obj -> g.apply((DescribeUserProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String domainId;
        private String userProfileArn;
        private String userProfileName;
        private String homeEfsFileSystemUid;
        private String status;
        private Instant lastModifiedTime;
        private Instant creationTime;
        private String failureReason;
        private String singleSignOnUserIdentifier;
        private String singleSignOnUserValue;
        private UserSettings userSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserProfileResponse model) {
            super(model);
            this.domainId(model.domainId);
            this.userProfileArn(model.userProfileArn);
            this.userProfileName(model.userProfileName);
            this.homeEfsFileSystemUid(model.homeEfsFileSystemUid);
            this.status(model.status);
            this.lastModifiedTime(model.lastModifiedTime);
            this.creationTime(model.creationTime);
            this.failureReason(model.failureReason);
            this.singleSignOnUserIdentifier(model.singleSignOnUserIdentifier);
            this.singleSignOnUserValue(model.singleSignOnUserValue);
            this.userSettings(model.userSettings);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        public final String getUserProfileArn() {
            return this.userProfileArn;
        }

        @Override
        public final Builder userProfileArn(String userProfileArn) {
            this.userProfileArn = userProfileArn;
            return this;
        }

        public final void setUserProfileArn(String userProfileArn) {
            this.userProfileArn = userProfileArn;
        }

        public final String getUserProfileName() {
            return this.userProfileName;
        }

        @Override
        public final Builder userProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
            return this;
        }

        public final void setUserProfileName(String userProfileName) {
            this.userProfileName = userProfileName;
        }

        public final String getHomeEfsFileSystemUid() {
            return this.homeEfsFileSystemUid;
        }

        @Override
        public final Builder homeEfsFileSystemUid(String homeEfsFileSystemUid) {
            this.homeEfsFileSystemUid = homeEfsFileSystemUid;
            return this;
        }

        public final void setHomeEfsFileSystemUid(String homeEfsFileSystemUid) {
            this.homeEfsFileSystemUid = homeEfsFileSystemUid;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UserProfileStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final String getSingleSignOnUserIdentifier() {
            return this.singleSignOnUserIdentifier;
        }

        @Override
        public final Builder singleSignOnUserIdentifier(String singleSignOnUserIdentifier) {
            this.singleSignOnUserIdentifier = singleSignOnUserIdentifier;
            return this;
        }

        public final void setSingleSignOnUserIdentifier(String singleSignOnUserIdentifier) {
            this.singleSignOnUserIdentifier = singleSignOnUserIdentifier;
        }

        public final String getSingleSignOnUserValue() {
            return this.singleSignOnUserValue;
        }

        @Override
        public final Builder singleSignOnUserValue(String singleSignOnUserValue) {
            this.singleSignOnUserValue = singleSignOnUserValue;
            return this;
        }

        public final void setSingleSignOnUserValue(String singleSignOnUserValue) {
            this.singleSignOnUserValue = singleSignOnUserValue;
        }

        public final UserSettings.Builder getUserSettings() {
            return this.userSettings != null ? this.userSettings.toBuilder() : null;
        }

        @Override
        public final Builder userSettings(UserSettings userSettings) {
            this.userSettings = userSettings;
            return this;
        }

        public final void setUserSettings(UserSettings.BuilderImpl userSettings) {
            this.userSettings = userSettings != null ? userSettings.build() : null;
        }

        @Override
        public DescribeUserProfileResponse build() {
            return new DescribeUserProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeUserProfileResponse> {
        public Builder domainId(String var1);

        public Builder userProfileArn(String var1);

        public Builder userProfileName(String var1);

        public Builder homeEfsFileSystemUid(String var1);

        public Builder status(String var1);

        public Builder status(UserProfileStatus var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder failureReason(String var1);

        public Builder singleSignOnUserIdentifier(String var1);

        public Builder singleSignOnUserValue(String var1);

        public Builder userSettings(UserSettings var1);

        default public Builder userSettings(Consumer<UserSettings.Builder> userSettings) {
            return this.userSettings((UserSettings)((UserSettings.Builder)UserSettings.builder().applyMutation(userSettings)).build());
        }
    }
}

