/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobResourceConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LabelingJobAlgorithmsConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LabelingJobAlgorithmsConfig> {
    private static final SdkField<String> LABELING_JOB_ALGORITHM_SPECIFICATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LabelingJobAlgorithmSpecificationArn").getter(LabelingJobAlgorithmsConfig.getter(LabelingJobAlgorithmsConfig::labelingJobAlgorithmSpecificationArn)).setter(LabelingJobAlgorithmsConfig.setter(Builder::labelingJobAlgorithmSpecificationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobAlgorithmSpecificationArn").build()}).build();
    private static final SdkField<String> INITIAL_ACTIVE_LEARNING_MODEL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InitialActiveLearningModelArn").getter(LabelingJobAlgorithmsConfig.getter(LabelingJobAlgorithmsConfig::initialActiveLearningModelArn)).setter(LabelingJobAlgorithmsConfig.setter(Builder::initialActiveLearningModelArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialActiveLearningModelArn").build()}).build();
    private static final SdkField<LabelingJobResourceConfig> LABELING_JOB_RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LabelingJobResourceConfig").getter(LabelingJobAlgorithmsConfig.getter(LabelingJobAlgorithmsConfig::labelingJobResourceConfig)).setter(LabelingJobAlgorithmsConfig.setter(Builder::labelingJobResourceConfig)).constructor(LabelingJobResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobResourceConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_ALGORITHM_SPECIFICATION_ARN_FIELD, INITIAL_ACTIVE_LEARNING_MODEL_ARN_FIELD, LABELING_JOB_RESOURCE_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String labelingJobAlgorithmSpecificationArn;
    private final String initialActiveLearningModelArn;
    private final LabelingJobResourceConfig labelingJobResourceConfig;

    private LabelingJobAlgorithmsConfig(BuilderImpl builder) {
        this.labelingJobAlgorithmSpecificationArn = builder.labelingJobAlgorithmSpecificationArn;
        this.initialActiveLearningModelArn = builder.initialActiveLearningModelArn;
        this.labelingJobResourceConfig = builder.labelingJobResourceConfig;
    }

    public String labelingJobAlgorithmSpecificationArn() {
        return this.labelingJobAlgorithmSpecificationArn;
    }

    public String initialActiveLearningModelArn() {
        return this.initialActiveLearningModelArn;
    }

    public LabelingJobResourceConfig labelingJobResourceConfig() {
        return this.labelingJobResourceConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobAlgorithmSpecificationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.initialActiveLearningModelArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobResourceConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LabelingJobAlgorithmsConfig)) {
            return false;
        }
        LabelingJobAlgorithmsConfig other = (LabelingJobAlgorithmsConfig)obj;
        return Objects.equals(this.labelingJobAlgorithmSpecificationArn(), other.labelingJobAlgorithmSpecificationArn()) && Objects.equals(this.initialActiveLearningModelArn(), other.initialActiveLearningModelArn()) && Objects.equals(this.labelingJobResourceConfig(), other.labelingJobResourceConfig());
    }

    public String toString() {
        return ToString.builder((String)"LabelingJobAlgorithmsConfig").add("LabelingJobAlgorithmSpecificationArn", (Object)this.labelingJobAlgorithmSpecificationArn()).add("InitialActiveLearningModelArn", (Object)this.initialActiveLearningModelArn()).add("LabelingJobResourceConfig", (Object)this.labelingJobResourceConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelingJobAlgorithmSpecificationArn": {
                return Optional.ofNullable(clazz.cast(this.labelingJobAlgorithmSpecificationArn()));
            }
            case "InitialActiveLearningModelArn": {
                return Optional.ofNullable(clazz.cast(this.initialActiveLearningModelArn()));
            }
            case "LabelingJobResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.labelingJobResourceConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LabelingJobAlgorithmsConfig, T> g) {
        return obj -> g.apply((LabelingJobAlgorithmsConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String labelingJobAlgorithmSpecificationArn;
        private String initialActiveLearningModelArn;
        private LabelingJobResourceConfig labelingJobResourceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(LabelingJobAlgorithmsConfig model) {
            this.labelingJobAlgorithmSpecificationArn(model.labelingJobAlgorithmSpecificationArn);
            this.initialActiveLearningModelArn(model.initialActiveLearningModelArn);
            this.labelingJobResourceConfig(model.labelingJobResourceConfig);
        }

        public final String getLabelingJobAlgorithmSpecificationArn() {
            return this.labelingJobAlgorithmSpecificationArn;
        }

        @Override
        public final Builder labelingJobAlgorithmSpecificationArn(String labelingJobAlgorithmSpecificationArn) {
            this.labelingJobAlgorithmSpecificationArn = labelingJobAlgorithmSpecificationArn;
            return this;
        }

        public final void setLabelingJobAlgorithmSpecificationArn(String labelingJobAlgorithmSpecificationArn) {
            this.labelingJobAlgorithmSpecificationArn = labelingJobAlgorithmSpecificationArn;
        }

        public final String getInitialActiveLearningModelArn() {
            return this.initialActiveLearningModelArn;
        }

        @Override
        public final Builder initialActiveLearningModelArn(String initialActiveLearningModelArn) {
            this.initialActiveLearningModelArn = initialActiveLearningModelArn;
            return this;
        }

        public final void setInitialActiveLearningModelArn(String initialActiveLearningModelArn) {
            this.initialActiveLearningModelArn = initialActiveLearningModelArn;
        }

        public final LabelingJobResourceConfig.Builder getLabelingJobResourceConfig() {
            return this.labelingJobResourceConfig != null ? this.labelingJobResourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder labelingJobResourceConfig(LabelingJobResourceConfig labelingJobResourceConfig) {
            this.labelingJobResourceConfig = labelingJobResourceConfig;
            return this;
        }

        public final void setLabelingJobResourceConfig(LabelingJobResourceConfig.BuilderImpl labelingJobResourceConfig) {
            this.labelingJobResourceConfig = labelingJobResourceConfig != null ? labelingJobResourceConfig.build() : null;
        }

        public LabelingJobAlgorithmsConfig build() {
            return new LabelingJobAlgorithmsConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LabelingJobAlgorithmsConfig> {
        public Builder labelingJobAlgorithmSpecificationArn(String var1);

        public Builder initialActiveLearningModelArn(String var1);

        public Builder labelingJobResourceConfig(LabelingJobResourceConfig var1);

        default public Builder labelingJobResourceConfig(Consumer<LabelingJobResourceConfig.Builder> labelingJobResourceConfig) {
            return this.labelingJobResourceConfig((LabelingJobResourceConfig)((LabelingJobResourceConfig.Builder)LabelingJobResourceConfig.builder().applyMutation(labelingJobResourceConfig)).build());
        }
    }
}

