/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ExecutionStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringExecutionSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringExecutionSummary> {
    private static final SdkField<String> MONITORING_SCHEDULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringScheduleName").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::monitoringScheduleName)).setter(MonitoringExecutionSummary.setter(Builder::monitoringScheduleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringScheduleName").build()}).build();
    private static final SdkField<Instant> SCHEDULED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ScheduledTime").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::scheduledTime)).setter(MonitoringExecutionSummary.setter(Builder::scheduledTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::creationTime)).setter(MonitoringExecutionSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::lastModifiedTime)).setter(MonitoringExecutionSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> MONITORING_EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MonitoringExecutionStatus").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::monitoringExecutionStatusAsString)).setter(MonitoringExecutionSummary.setter(Builder::monitoringExecutionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MonitoringExecutionStatus").build()}).build();
    private static final SdkField<String> PROCESSING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProcessingJobArn").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::processingJobArn)).setter(MonitoringExecutionSummary.setter(Builder::processingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProcessingJobArn").build()}).build();
    private static final SdkField<String> ENDPOINT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EndpointName").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::endpointName)).setter(MonitoringExecutionSummary.setter(Builder::endpointName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointName").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(MonitoringExecutionSummary.getter(MonitoringExecutionSummary::failureReason)).setter(MonitoringExecutionSummary.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITORING_SCHEDULE_NAME_FIELD, SCHEDULED_TIME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, MONITORING_EXECUTION_STATUS_FIELD, PROCESSING_JOB_ARN_FIELD, ENDPOINT_NAME_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final String monitoringScheduleName;
    private final Instant scheduledTime;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String monitoringExecutionStatus;
    private final String processingJobArn;
    private final String endpointName;
    private final String failureReason;

    private MonitoringExecutionSummary(BuilderImpl builder) {
        this.monitoringScheduleName = builder.monitoringScheduleName;
        this.scheduledTime = builder.scheduledTime;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.monitoringExecutionStatus = builder.monitoringExecutionStatus;
        this.processingJobArn = builder.processingJobArn;
        this.endpointName = builder.endpointName;
        this.failureReason = builder.failureReason;
    }

    public String monitoringScheduleName() {
        return this.monitoringScheduleName;
    }

    public Instant scheduledTime() {
        return this.scheduledTime;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public ExecutionStatus monitoringExecutionStatus() {
        return ExecutionStatus.fromValue(this.monitoringExecutionStatus);
    }

    public String monitoringExecutionStatusAsString() {
        return this.monitoringExecutionStatus;
    }

    public String processingJobArn() {
        return this.processingJobArn;
    }

    public String endpointName() {
        return this.endpointName;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringScheduleName());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.monitoringExecutionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointName());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringExecutionSummary)) {
            return false;
        }
        MonitoringExecutionSummary other = (MonitoringExecutionSummary)obj;
        return Objects.equals(this.monitoringScheduleName(), other.monitoringScheduleName()) && Objects.equals(this.scheduledTime(), other.scheduledTime()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.monitoringExecutionStatusAsString(), other.monitoringExecutionStatusAsString()) && Objects.equals(this.processingJobArn(), other.processingJobArn()) && Objects.equals(this.endpointName(), other.endpointName()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public String toString() {
        return ToString.builder((String)"MonitoringExecutionSummary").add("MonitoringScheduleName", (Object)this.monitoringScheduleName()).add("ScheduledTime", (Object)this.scheduledTime()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("MonitoringExecutionStatus", (Object)this.monitoringExecutionStatusAsString()).add("ProcessingJobArn", (Object)this.processingJobArn()).add("EndpointName", (Object)this.endpointName()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MonitoringScheduleName": {
                return Optional.ofNullable(clazz.cast(this.monitoringScheduleName()));
            }
            case "ScheduledTime": {
                return Optional.ofNullable(clazz.cast(this.scheduledTime()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "MonitoringExecutionStatus": {
                return Optional.ofNullable(clazz.cast(this.monitoringExecutionStatusAsString()));
            }
            case "ProcessingJobArn": {
                return Optional.ofNullable(clazz.cast(this.processingJobArn()));
            }
            case "EndpointName": {
                return Optional.ofNullable(clazz.cast(this.endpointName()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringExecutionSummary, T> g) {
        return obj -> g.apply((MonitoringExecutionSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String monitoringScheduleName;
        private Instant scheduledTime;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String monitoringExecutionStatus;
        private String processingJobArn;
        private String endpointName;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringExecutionSummary model) {
            this.monitoringScheduleName(model.monitoringScheduleName);
            this.scheduledTime(model.scheduledTime);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.monitoringExecutionStatus(model.monitoringExecutionStatus);
            this.processingJobArn(model.processingJobArn);
            this.endpointName(model.endpointName);
            this.failureReason(model.failureReason);
        }

        public final String getMonitoringScheduleName() {
            return this.monitoringScheduleName;
        }

        @Override
        public final Builder monitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
            return this;
        }

        public final void setMonitoringScheduleName(String monitoringScheduleName) {
            this.monitoringScheduleName = monitoringScheduleName;
        }

        public final Instant getScheduledTime() {
            return this.scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final void setScheduledTime(Instant scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getMonitoringExecutionStatus() {
            return this.monitoringExecutionStatus;
        }

        @Override
        public final Builder monitoringExecutionStatus(String monitoringExecutionStatus) {
            this.monitoringExecutionStatus = monitoringExecutionStatus;
            return this;
        }

        @Override
        public final Builder monitoringExecutionStatus(ExecutionStatus monitoringExecutionStatus) {
            this.monitoringExecutionStatus(monitoringExecutionStatus == null ? null : monitoringExecutionStatus.toString());
            return this;
        }

        public final void setMonitoringExecutionStatus(String monitoringExecutionStatus) {
            this.monitoringExecutionStatus = monitoringExecutionStatus;
        }

        public final String getProcessingJobArn() {
            return this.processingJobArn;
        }

        @Override
        public final Builder processingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
            return this;
        }

        public final void setProcessingJobArn(String processingJobArn) {
            this.processingJobArn = processingJobArn;
        }

        public final String getEndpointName() {
            return this.endpointName;
        }

        @Override
        public final Builder endpointName(String endpointName) {
            this.endpointName = endpointName;
            return this;
        }

        public final void setEndpointName(String endpointName) {
            this.endpointName = endpointName;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public MonitoringExecutionSummary build() {
            return new MonitoringExecutionSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringExecutionSummary> {
        public Builder monitoringScheduleName(String var1);

        public Builder scheduledTime(Instant var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder monitoringExecutionStatus(String var1);

        public Builder monitoringExecutionStatus(ExecutionStatus var1);

        public Builder processingJobArn(String var1);

        public Builder endpointName(String var1);

        public Builder failureReason(String var1);
    }
}

