/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemakera2iruntime.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListHumanLoopsRequest extends SageMakerA2IRuntimeRequest implements
        ToCopyableBuilder<ListHumanLoopsRequest.Builder, ListHumanLoopsRequest> {
    private static final SdkField<Instant> CREATION_TIME_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeAfter").getter(getter(ListHumanLoopsRequest::creationTimeAfter))
            .setter(setter(Builder::creationTimeAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CreationTimeAfter").build())
            .build();

    private static final SdkField<Instant> CREATION_TIME_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTimeBefore").getter(getter(ListHumanLoopsRequest::creationTimeBefore))
            .setter(setter(Builder::creationTimeBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("CreationTimeBefore").build())
            .build();

    private static final SdkField<String> FLOW_DEFINITION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FlowDefinitionArn").getter(getter(ListHumanLoopsRequest::flowDefinitionArn))
            .setter(setter(Builder::flowDefinitionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("FlowDefinitionArn").build())
            .build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(ListHumanLoopsRequest::sortOrderAsString)).setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("SortOrder").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListHumanLoopsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListHumanLoopsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_AFTER_FIELD,
            CREATION_TIME_BEFORE_FIELD, FLOW_DEFINITION_ARN_FIELD, SORT_ORDER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final Instant creationTimeAfter;

    private final Instant creationTimeBefore;

    private final String flowDefinitionArn;

    private final String sortOrder;

    private final String nextToken;

    private final Integer maxResults;

    private ListHumanLoopsRequest(BuilderImpl builder) {
        super(builder);
        this.creationTimeAfter = builder.creationTimeAfter;
        this.creationTimeBefore = builder.creationTimeBefore;
        this.flowDefinitionArn = builder.flowDefinitionArn;
        this.sortOrder = builder.sortOrder;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * (Optional) The timestamp of the date when you want the human loops to begin in ISO 8601 format. For example,
     * <code>2020-02-24</code>.
     * </p>
     * 
     * @return (Optional) The timestamp of the date when you want the human loops to begin in ISO 8601 format. For
     *         example, <code>2020-02-24</code>.
     */
    public Instant creationTimeAfter() {
        return creationTimeAfter;
    }

    /**
     * <p>
     * (Optional) The timestamp of the date before which you want the human loops to begin in ISO 8601 format. For
     * example, <code>2020-02-24</code>.
     * </p>
     * 
     * @return (Optional) The timestamp of the date before which you want the human loops to begin in ISO 8601 format.
     *         For example, <code>2020-02-24</code>.
     */
    public Instant creationTimeBefore() {
        return creationTimeBefore;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of a flow definition.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of a flow definition.
     */
    public String flowDefinitionArn() {
        return flowDefinitionArn;
    }

    /**
     * <p>
     * Optional. The order for displaying results. Valid values: <code>Ascending</code> and <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Optional. The order for displaying results. Valid values: <code>Ascending</code> and
     *         <code>Descending</code>.
     * @see SortOrder
     */
    public SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Optional. The order for displaying results. Valid values: <code>Ascending</code> and <code>Descending</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Optional. The order for displaying results. Valid values: <code>Ascending</code> and
     *         <code>Descending</code>.
     * @see SortOrder
     */
    public String sortOrderAsString() {
        return sortOrder;
    }

    /**
     * <p>
     * A token to display the next page of results.
     * </p>
     * 
     * @return A token to display the next page of results.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The total number of items to return. If the total number of available items is more than the value specified in
     * <code>MaxResults</code>, then a <code>NextToken</code> is returned in the output. You can use this token to
     * display the next page of results.
     * </p>
     * 
     * @return The total number of items to return. If the total number of available items is more than the value
     *         specified in <code>MaxResults</code>, then a <code>NextToken</code> is returned in the output. You can
     *         use this token to display the next page of results.
     */
    public Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeAfter());
        hashCode = 31 * hashCode + Objects.hashCode(creationTimeBefore());
        hashCode = 31 * hashCode + Objects.hashCode(flowDefinitionArn());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHumanLoopsRequest)) {
            return false;
        }
        ListHumanLoopsRequest other = (ListHumanLoopsRequest) obj;
        return Objects.equals(creationTimeAfter(), other.creationTimeAfter())
                && Objects.equals(creationTimeBefore(), other.creationTimeBefore())
                && Objects.equals(flowDefinitionArn(), other.flowDefinitionArn())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListHumanLoopsRequest").add("CreationTimeAfter", creationTimeAfter())
                .add("CreationTimeBefore", creationTimeBefore()).add("FlowDefinitionArn", flowDefinitionArn())
                .add("SortOrder", sortOrderAsString()).add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTimeAfter":
            return Optional.ofNullable(clazz.cast(creationTimeAfter()));
        case "CreationTimeBefore":
            return Optional.ofNullable(clazz.cast(creationTimeBefore()));
        case "FlowDefinitionArn":
            return Optional.ofNullable(clazz.cast(flowDefinitionArn()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListHumanLoopsRequest, T> g) {
        return obj -> g.apply((ListHumanLoopsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerA2IRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListHumanLoopsRequest> {
        /**
         * <p>
         * (Optional) The timestamp of the date when you want the human loops to begin in ISO 8601 format. For example,
         * <code>2020-02-24</code>.
         * </p>
         * 
         * @param creationTimeAfter
         *        (Optional) The timestamp of the date when you want the human loops to begin in ISO 8601 format. For
         *        example, <code>2020-02-24</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeAfter(Instant creationTimeAfter);

        /**
         * <p>
         * (Optional) The timestamp of the date before which you want the human loops to begin in ISO 8601 format. For
         * example, <code>2020-02-24</code>.
         * </p>
         * 
         * @param creationTimeBefore
         *        (Optional) The timestamp of the date before which you want the human loops to begin in ISO 8601
         *        format. For example, <code>2020-02-24</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTimeBefore(Instant creationTimeBefore);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of a flow definition.
         * </p>
         * 
         * @param flowDefinitionArn
         *        The Amazon Resource Name (ARN) of a flow definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder flowDefinitionArn(String flowDefinitionArn);

        /**
         * <p>
         * Optional. The order for displaying results. Valid values: <code>Ascending</code> and <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        Optional. The order for displaying results. Valid values: <code>Ascending</code> and
         *        <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Optional. The order for displaying results. Valid values: <code>Ascending</code> and <code>Descending</code>.
         * </p>
         * 
         * @param sortOrder
         *        Optional. The order for displaying results. Valid values: <code>Ascending</code> and
         *        <code>Descending</code>.
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);

        /**
         * <p>
         * A token to display the next page of results.
         * </p>
         * 
         * @param nextToken
         *        A token to display the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The total number of items to return. If the total number of available items is more than the value specified
         * in <code>MaxResults</code>, then a <code>NextToken</code> is returned in the output. You can use this token
         * to display the next page of results.
         * </p>
         * 
         * @param maxResults
         *        The total number of items to return. If the total number of available items is more than the value
         *        specified in <code>MaxResults</code>, then a <code>NextToken</code> is returned in the output. You can
         *        use this token to display the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerA2IRuntimeRequest.BuilderImpl implements Builder {
        private Instant creationTimeAfter;

        private Instant creationTimeBefore;

        private String flowDefinitionArn;

        private String sortOrder;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHumanLoopsRequest model) {
            super(model);
            creationTimeAfter(model.creationTimeAfter);
            creationTimeBefore(model.creationTimeBefore);
            flowDefinitionArn(model.flowDefinitionArn);
            sortOrder(model.sortOrder);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final Instant getCreationTimeAfter() {
            return creationTimeAfter;
        }

        @Override
        public final Builder creationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
            return this;
        }

        public final void setCreationTimeAfter(Instant creationTimeAfter) {
            this.creationTimeAfter = creationTimeAfter;
        }

        public final Instant getCreationTimeBefore() {
            return creationTimeBefore;
        }

        @Override
        public final Builder creationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
            return this;
        }

        public final void setCreationTimeBefore(Instant creationTimeBefore) {
            this.creationTimeBefore = creationTimeBefore;
        }

        public final String getFlowDefinitionArn() {
            return flowDefinitionArn;
        }

        @Override
        public final Builder flowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
            return this;
        }

        public final void setFlowDefinitionArn(String flowDefinitionArn) {
            this.flowDefinitionArn = flowDefinitionArn;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListHumanLoopsRequest build() {
            return new ListHumanLoopsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
