/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Policy statement applied to the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationPolicyStatement implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationPolicyStatement.Builder, ApplicationPolicyStatement> {
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Actions")
            .getter(getter(ApplicationPolicyStatement::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PRINCIPAL_ORG_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrincipalOrgIDs")
            .getter(getter(ApplicationPolicyStatement::principalOrgIDs))
            .setter(setter(Builder::principalOrgIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalOrgIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> PRINCIPALS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Principals")
            .getter(getter(ApplicationPolicyStatement::principals))
            .setter(setter(Builder::principals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatementId").getter(getter(ApplicationPolicyStatement::statementId))
            .setter(setter(Builder::statementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statementId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD,
            PRINCIPAL_ORG_I_DS_FIELD, PRINCIPALS_FIELD, STATEMENT_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> actions;

    private final List<String> principalOrgIDs;

    private final List<String> principals;

    private final String statementId;

    private ApplicationPolicyStatement(BuilderImpl builder) {
        this.actions = builder.actions;
        this.principalOrgIDs = builder.principalOrgIDs;
        this.principals = builder.principals;
        this.statementId = builder.statementId;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * For the list of actions supported for this operation, see <a href=
     * "https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions"
     * >Application Permissions</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return For the list of actions supported for this operation, see <a href=
     *         "https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions"
     *         >Application Permissions</a>.
     */
    public List<String> actions() {
        return actions;
    }

    /**
     * Returns true if the PrincipalOrgIDs property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasPrincipalOrgIDs() {
        return principalOrgIDs != null && !(principalOrgIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of PrinciplalOrgIDs, which corresponds to AWS IAM <a
     * href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#principal-org-id"
     * >aws:PrincipalOrgID</a> global condition key.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrincipalOrgIDs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of PrinciplalOrgIDs, which corresponds to AWS IAM <a
     *         href="https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#principal-org-id"
     *         >aws:PrincipalOrgID</a> global condition key.
     */
    public List<String> principalOrgIDs() {
        return principalOrgIDs;
    }

    /**
     * Returns true if the Principals property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasPrincipals() {
        return principals != null && !(principals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of AWS account IDs, or * to make the application public.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrincipals()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of AWS account IDs, or * to make the application public.
     */
    public List<String> principals() {
        return principals;
    }

    /**
     * <p>
     * A unique ID for the statement.
     * </p>
     * 
     * @return A unique ID for the statement.
     */
    public String statementId() {
        return statementId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actions());
        hashCode = 31 * hashCode + Objects.hashCode(principalOrgIDs());
        hashCode = 31 * hashCode + Objects.hashCode(principals());
        hashCode = 31 * hashCode + Objects.hashCode(statementId());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationPolicyStatement)) {
            return false;
        }
        ApplicationPolicyStatement other = (ApplicationPolicyStatement) obj;
        return Objects.equals(actions(), other.actions()) && Objects.equals(principalOrgIDs(), other.principalOrgIDs())
                && Objects.equals(principals(), other.principals()) && Objects.equals(statementId(), other.statementId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplicationPolicyStatement").add("Actions", actions()).add("PrincipalOrgIDs", principalOrgIDs())
                .add("Principals", principals()).add("StatementId", statementId()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "PrincipalOrgIDs":
            return Optional.ofNullable(clazz.cast(principalOrgIDs()));
        case "Principals":
            return Optional.ofNullable(clazz.cast(principals()));
        case "StatementId":
            return Optional.ofNullable(clazz.cast(statementId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationPolicyStatement, T> g) {
        return obj -> g.apply((ApplicationPolicyStatement) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationPolicyStatement> {
        /**
         * <p>
         * For the list of actions supported for this operation, see <a href=
         * "https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions"
         * >Application Permissions</a>.
         * </p>
         * 
         * @param actions
         *        For the list of actions supported for this operation, see <a href=
         *        "https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions"
         *        >Application Permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * For the list of actions supported for this operation, see <a href=
         * "https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions"
         * >Application Permissions</a>.
         * </p>
         * 
         * @param actions
         *        For the list of actions supported for this operation, see <a href=
         *        "https://docs.aws.amazon.com/serverlessrepo/latest/devguide/access-control-resource-based.html#application-permissions"
         *        >Application Permissions</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);

        /**
         * <p>
         * An array of PrinciplalOrgIDs, which corresponds to AWS IAM <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#principal-org-id"
         * >aws:PrincipalOrgID</a> global condition key.
         * </p>
         * 
         * @param principalOrgIDs
         *        An array of PrinciplalOrgIDs, which corresponds to AWS IAM <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#principal-org-id"
         *        >aws:PrincipalOrgID</a> global condition key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalOrgIDs(Collection<String> principalOrgIDs);

        /**
         * <p>
         * An array of PrinciplalOrgIDs, which corresponds to AWS IAM <a href=
         * "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#principal-org-id"
         * >aws:PrincipalOrgID</a> global condition key.
         * </p>
         * 
         * @param principalOrgIDs
         *        An array of PrinciplalOrgIDs, which corresponds to AWS IAM <a href=
         *        "https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#principal-org-id"
         *        >aws:PrincipalOrgID</a> global condition key.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalOrgIDs(String... principalOrgIDs);

        /**
         * <p>
         * An array of AWS account IDs, or * to make the application public.
         * </p>
         * 
         * @param principals
         *        An array of AWS account IDs, or * to make the application public.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(Collection<String> principals);

        /**
         * <p>
         * An array of AWS account IDs, or * to make the application public.
         * </p>
         * 
         * @param principals
         *        An array of AWS account IDs, or * to make the application public.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principals(String... principals);

        /**
         * <p>
         * A unique ID for the statement.
         * </p>
         * 
         * @param statementId
         *        A unique ID for the statement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statementId(String statementId);
    }

    static final class BuilderImpl implements Builder {
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private List<String> principalOrgIDs = DefaultSdkAutoConstructList.getInstance();

        private List<String> principals = DefaultSdkAutoConstructList.getInstance();

        private String statementId;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationPolicyStatement model) {
            actions(model.actions);
            principalOrgIDs(model.principalOrgIDs);
            principals(model.principals);
            statementId(model.statementId);
        }

        public final Collection<String> getActions() {
            return actions;
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ___listOf__stringCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ___listOf__stringCopier.copy(actions);
        }

        public final Collection<String> getPrincipalOrgIDs() {
            return principalOrgIDs;
        }

        @Override
        public final Builder principalOrgIDs(Collection<String> principalOrgIDs) {
            this.principalOrgIDs = ___listOf__stringCopier.copy(principalOrgIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principalOrgIDs(String... principalOrgIDs) {
            principalOrgIDs(Arrays.asList(principalOrgIDs));
            return this;
        }

        public final void setPrincipalOrgIDs(Collection<String> principalOrgIDs) {
            this.principalOrgIDs = ___listOf__stringCopier.copy(principalOrgIDs);
        }

        public final Collection<String> getPrincipals() {
            return principals;
        }

        @Override
        public final Builder principals(Collection<String> principals) {
            this.principals = ___listOf__stringCopier.copy(principals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder principals(String... principals) {
            principals(Arrays.asList(principals));
            return this;
        }

        public final void setPrincipals(Collection<String> principals) {
            this.principals = ___listOf__stringCopier.copy(principals);
        }

        public final String getStatementId() {
            return statementId;
        }

        @Override
        public final Builder statementId(String statementId) {
            this.statementId = statementId;
            return this;
        }

        public final void setStatementId(String statementId) {
            this.statementId = statementId;
        }

        @Override
        public ApplicationPolicyStatement build() {
            return new ApplicationPolicyStatement(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
