/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationVersionRequest extends ServerlessApplicationRepositoryRequest implements
        ToCopyableBuilder<CreateApplicationVersionRequest.Builder, CreateApplicationVersionRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationId").getter(getter(CreateApplicationVersionRequest::applicationId))
            .setter(setter(Builder::applicationId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("applicationId").build()).build();

    private static final SdkField<String> SEMANTIC_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SemanticVersion").getter(getter(CreateApplicationVersionRequest::semanticVersion))
            .setter(setter(Builder::semanticVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("semanticVersion").build()).build();

    private static final SdkField<String> SOURCE_CODE_ARCHIVE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceCodeArchiveUrl").getter(getter(CreateApplicationVersionRequest::sourceCodeArchiveUrl))
            .setter(setter(Builder::sourceCodeArchiveUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeArchiveUrl").build())
            .build();

    private static final SdkField<String> SOURCE_CODE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceCodeUrl").getter(getter(CreateApplicationVersionRequest::sourceCodeUrl))
            .setter(setter(Builder::sourceCodeUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceCodeUrl").build()).build();

    private static final SdkField<String> TEMPLATE_BODY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateBody").getter(getter(CreateApplicationVersionRequest::templateBody))
            .setter(setter(Builder::templateBody))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateBody").build()).build();

    private static final SdkField<String> TEMPLATE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateUrl").getter(getter(CreateApplicationVersionRequest::templateUrl))
            .setter(setter(Builder::templateUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPLICATION_ID_FIELD, SEMANTIC_VERSION_FIELD, SOURCE_CODE_ARCHIVE_URL_FIELD, SOURCE_CODE_URL_FIELD,
                    TEMPLATE_BODY_FIELD, TEMPLATE_URL_FIELD));

    private final String applicationId;

    private final String semanticVersion;

    private final String sourceCodeArchiveUrl;

    private final String sourceCodeUrl;

    private final String templateBody;

    private final String templateUrl;

    private CreateApplicationVersionRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.semanticVersion = builder.semanticVersion;
        this.sourceCodeArchiveUrl = builder.sourceCodeArchiveUrl;
        this.sourceCodeUrl = builder.sourceCodeUrl;
        this.templateBody = builder.templateBody;
        this.templateUrl = builder.templateUrl;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the application.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the application.
     */
    public String applicationId() {
        return applicationId;
    }

    /**
     * <p>
     * The semantic version of the new version.
     * </p>
     * 
     * @return The semantic version of the new version.
     */
    public String semanticVersion() {
        return semanticVersion;
    }

    /**
     * <p>
     * A link to the S3 object that contains the ZIP archive of the source code for this version of your application.
     * </p>
     * <p>
     * Maximum size 50 MB
     * </p>
     * 
     * @return A link to the S3 object that contains the ZIP archive of the source code for this version of your
     *         application.</p>
     *         <p>
     *         Maximum size 50 MB
     */
    public String sourceCodeArchiveUrl() {
        return sourceCodeArchiveUrl;
    }

    /**
     * <p>
     * A link to a public repository for the source code of your application, for example the URL of a specific GitHub
     * commit.
     * </p>
     * 
     * @return A link to a public repository for the source code of your application, for example the URL of a specific
     *         GitHub commit.
     */
    public String sourceCodeUrl() {
        return sourceCodeUrl;
    }

    /**
     * <p>
     * The raw packaged AWS SAM template of your application.
     * </p>
     * 
     * @return The raw packaged AWS SAM template of your application.
     */
    public String templateBody() {
        return templateBody;
    }

    /**
     * <p>
     * A link to the packaged AWS SAM template of your application.
     * </p>
     * 
     * @return A link to the packaged AWS SAM template of your application.
     */
    public String templateUrl() {
        return templateUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(semanticVersion());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeArchiveUrl());
        hashCode = 31 * hashCode + Objects.hashCode(sourceCodeUrl());
        hashCode = 31 * hashCode + Objects.hashCode(templateBody());
        hashCode = 31 * hashCode + Objects.hashCode(templateUrl());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationVersionRequest)) {
            return false;
        }
        CreateApplicationVersionRequest other = (CreateApplicationVersionRequest) obj;
        return Objects.equals(applicationId(), other.applicationId())
                && Objects.equals(semanticVersion(), other.semanticVersion())
                && Objects.equals(sourceCodeArchiveUrl(), other.sourceCodeArchiveUrl())
                && Objects.equals(sourceCodeUrl(), other.sourceCodeUrl()) && Objects.equals(templateBody(), other.templateBody())
                && Objects.equals(templateUrl(), other.templateUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("CreateApplicationVersionRequest").add("ApplicationId", applicationId())
                .add("SemanticVersion", semanticVersion()).add("SourceCodeArchiveUrl", sourceCodeArchiveUrl())
                .add("SourceCodeUrl", sourceCodeUrl()).add("TemplateBody", templateBody()).add("TemplateUrl", templateUrl())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApplicationId":
            return Optional.ofNullable(clazz.cast(applicationId()));
        case "SemanticVersion":
            return Optional.ofNullable(clazz.cast(semanticVersion()));
        case "SourceCodeArchiveUrl":
            return Optional.ofNullable(clazz.cast(sourceCodeArchiveUrl()));
        case "SourceCodeUrl":
            return Optional.ofNullable(clazz.cast(sourceCodeUrl()));
        case "TemplateBody":
            return Optional.ofNullable(clazz.cast(templateBody()));
        case "TemplateUrl":
            return Optional.ofNullable(clazz.cast(templateUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationVersionRequest, T> g) {
        return obj -> g.apply((CreateApplicationVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServerlessApplicationRepositoryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateApplicationVersionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the application.
         * </p>
         * 
         * @param applicationId
         *        The Amazon Resource Name (ARN) of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationId(String applicationId);

        /**
         * <p>
         * The semantic version of the new version.
         * </p>
         * 
         * @param semanticVersion
         *        The semantic version of the new version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder semanticVersion(String semanticVersion);

        /**
         * <p>
         * A link to the S3 object that contains the ZIP archive of the source code for this version of your
         * application.
         * </p>
         * <p>
         * Maximum size 50 MB
         * </p>
         * 
         * @param sourceCodeArchiveUrl
         *        A link to the S3 object that contains the ZIP archive of the source code for this version of your
         *        application.</p>
         *        <p>
         *        Maximum size 50 MB
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeArchiveUrl(String sourceCodeArchiveUrl);

        /**
         * <p>
         * A link to a public repository for the source code of your application, for example the URL of a specific
         * GitHub commit.
         * </p>
         * 
         * @param sourceCodeUrl
         *        A link to a public repository for the source code of your application, for example the URL of a
         *        specific GitHub commit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceCodeUrl(String sourceCodeUrl);

        /**
         * <p>
         * The raw packaged AWS SAM template of your application.
         * </p>
         * 
         * @param templateBody
         *        The raw packaged AWS SAM template of your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateBody(String templateBody);

        /**
         * <p>
         * A link to the packaged AWS SAM template of your application.
         * </p>
         * 
         * @param templateUrl
         *        A link to the packaged AWS SAM template of your application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateUrl(String templateUrl);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ServerlessApplicationRepositoryRequest.BuilderImpl implements Builder {
        private String applicationId;

        private String semanticVersion;

        private String sourceCodeArchiveUrl;

        private String sourceCodeUrl;

        private String templateBody;

        private String templateUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationVersionRequest model) {
            super(model);
            applicationId(model.applicationId);
            semanticVersion(model.semanticVersion);
            sourceCodeArchiveUrl(model.sourceCodeArchiveUrl);
            sourceCodeUrl(model.sourceCodeUrl);
            templateBody(model.templateBody);
            templateUrl(model.templateUrl);
        }

        public final String getApplicationId() {
            return applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        public final String getSemanticVersion() {
            return semanticVersion;
        }

        @Override
        public final Builder semanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
            return this;
        }

        public final void setSemanticVersion(String semanticVersion) {
            this.semanticVersion = semanticVersion;
        }

        public final String getSourceCodeArchiveUrl() {
            return sourceCodeArchiveUrl;
        }

        @Override
        public final Builder sourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
            return this;
        }

        public final void setSourceCodeArchiveUrl(String sourceCodeArchiveUrl) {
            this.sourceCodeArchiveUrl = sourceCodeArchiveUrl;
        }

        public final String getSourceCodeUrl() {
            return sourceCodeUrl;
        }

        @Override
        public final Builder sourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
            return this;
        }

        public final void setSourceCodeUrl(String sourceCodeUrl) {
            this.sourceCodeUrl = sourceCodeUrl;
        }

        public final String getTemplateBody() {
            return templateBody;
        }

        @Override
        public final Builder templateBody(String templateBody) {
            this.templateBody = templateBody;
            return this;
        }

        public final void setTemplateBody(String templateBody) {
            this.templateBody = templateBody;
        }

        public final String getTemplateUrl() {
            return templateUrl;
        }

        @Override
        public final Builder templateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
            return this;
        }

        public final void setTemplateUrl(String templateUrl) {
            this.templateUrl = templateUrl;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationVersionRequest build() {
            return new CreateApplicationVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
