/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.serverlessapplicationrepository.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Parameters supported by the application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParameterDefinition implements SdkPojo, Serializable,
        ToCopyableBuilder<ParameterDefinition.Builder, ParameterDefinition> {
    private static final SdkField<String> ALLOWED_PATTERN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AllowedPattern").getter(getter(ParameterDefinition::allowedPattern))
            .setter(setter(Builder::allowedPattern))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedPattern").build()).build();

    private static final SdkField<List<String>> ALLOWED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedValues")
            .getter(getter(ParameterDefinition::allowedValues))
            .setter(setter(Builder::allowedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONSTRAINT_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConstraintDescription").getter(getter(ParameterDefinition::constraintDescription))
            .setter(setter(Builder::constraintDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constraintDescription").build())
            .build();

    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(ParameterDefinition::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ParameterDefinition::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Integer> MAX_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxLength").getter(getter(ParameterDefinition::maxLength)).setter(setter(Builder::maxLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxLength").build()).build();

    private static final SdkField<Integer> MAX_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxValue").getter(getter(ParameterDefinition::maxValue)).setter(setter(Builder::maxValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxValue").build()).build();

    private static final SdkField<Integer> MIN_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinLength").getter(getter(ParameterDefinition::minLength)).setter(setter(Builder::minLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minLength").build()).build();

    private static final SdkField<Integer> MIN_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MinValue").getter(getter(ParameterDefinition::minValue)).setter(setter(Builder::minValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minValue").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ParameterDefinition::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Boolean> NO_ECHO_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("NoEcho").getter(getter(ParameterDefinition::noEcho)).setter(setter(Builder::noEcho))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("noEcho").build()).build();

    private static final SdkField<List<String>> REFERENCED_BY_RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReferencedByResources")
            .getter(getter(ParameterDefinition::referencedByResources))
            .setter(setter(Builder::referencedByResources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referencedByResources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ParameterDefinition::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOWED_PATTERN_FIELD,
            ALLOWED_VALUES_FIELD, CONSTRAINT_DESCRIPTION_FIELD, DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD, MAX_LENGTH_FIELD,
            MAX_VALUE_FIELD, MIN_LENGTH_FIELD, MIN_VALUE_FIELD, NAME_FIELD, NO_ECHO_FIELD, REFERENCED_BY_RESOURCES_FIELD,
            TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String allowedPattern;

    private final List<String> allowedValues;

    private final String constraintDescription;

    private final String defaultValue;

    private final String description;

    private final Integer maxLength;

    private final Integer maxValue;

    private final Integer minLength;

    private final Integer minValue;

    private final String name;

    private final Boolean noEcho;

    private final List<String> referencedByResources;

    private final String type;

    private ParameterDefinition(BuilderImpl builder) {
        this.allowedPattern = builder.allowedPattern;
        this.allowedValues = builder.allowedValues;
        this.constraintDescription = builder.constraintDescription;
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.maxLength = builder.maxLength;
        this.maxValue = builder.maxValue;
        this.minLength = builder.minLength;
        this.minValue = builder.minValue;
        this.name = builder.name;
        this.noEcho = builder.noEcho;
        this.referencedByResources = builder.referencedByResources;
        this.type = builder.type;
    }

    /**
     * <p>
     * A regular expression that represents the patterns to allow for String types.
     * </p>
     * 
     * @return A regular expression that represents the patterns to allow for String types.
     */
    public String allowedPattern() {
        return allowedPattern;
    }

    /**
     * Returns true if the AllowedValues property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasAllowedValues() {
        return allowedValues != null && !(allowedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array containing the list of values allowed for the parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAllowedValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array containing the list of values allowed for the parameter.
     */
    public List<String> allowedValues() {
        return allowedValues;
    }

    /**
     * <p>
     * A string that explains a constraint when the constraint is violated. For example, without a constraint
     * description, a parameter that has an allowed pattern of [A-Za-z0-9]+ displays the following error message when
     * the user specifies an invalid value:
     * </p>
     * <p>
     * Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+
     * </p>
     * <p>
     * By adding a constraint description, such as "must contain only uppercase and lowercase letters and numbers," you
     * can display the following customized error message:
     * </p>
     * <p>
     * Malformed input-Parameter MyParameter must contain only uppercase and lowercase letters and numbers.
     * </p>
     * 
     * @return A string that explains a constraint when the constraint is violated. For example, without a constraint
     *         description, a parameter that has an allowed pattern of [A-Za-z0-9]+ displays the following error message
     *         when the user specifies an invalid value:</p>
     *         <p>
     *         Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+
     *         </p>
     *         <p>
     *         By adding a constraint description, such as
     *         "must contain only uppercase and lowercase letters and numbers," you can display the following customized
     *         error message:
     *         </p>
     *         <p>
     *         Malformed input-Parameter MyParameter must contain only uppercase and lowercase letters and numbers.
     */
    public String constraintDescription() {
        return constraintDescription;
    }

    /**
     * <p>
     * A value of the appropriate type for the template to use if no value is specified when a stack is created. If you
     * define constraints for the parameter, you must specify a value that adheres to those constraints.
     * </p>
     * 
     * @return A value of the appropriate type for the template to use if no value is specified when a stack is created.
     *         If you define constraints for the parameter, you must specify a value that adheres to those constraints.
     */
    public String defaultValue() {
        return defaultValue;
    }

    /**
     * <p>
     * A string of up to 4,000 characters that describes the parameter.
     * </p>
     * 
     * @return A string of up to 4,000 characters that describes the parameter.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * An integer value that determines the largest number of characters that you want to allow for String types.
     * </p>
     * 
     * @return An integer value that determines the largest number of characters that you want to allow for String
     *         types.
     */
    public Integer maxLength() {
        return maxLength;
    }

    /**
     * <p>
     * A numeric value that determines the largest numeric value that you want to allow for Number types.
     * </p>
     * 
     * @return A numeric value that determines the largest numeric value that you want to allow for Number types.
     */
    public Integer maxValue() {
        return maxValue;
    }

    /**
     * <p>
     * An integer value that determines the smallest number of characters that you want to allow for String types.
     * </p>
     * 
     * @return An integer value that determines the smallest number of characters that you want to allow for String
     *         types.
     */
    public Integer minLength() {
        return minLength;
    }

    /**
     * <p>
     * A numeric value that determines the smallest numeric value that you want to allow for Number types.
     * </p>
     * 
     * @return A numeric value that determines the smallest numeric value that you want to allow for Number types.
     */
    public Integer minValue() {
        return minValue;
    }

    /**
     * <p>
     * The name of the parameter.
     * </p>
     * 
     * @return The name of the parameter.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * Whether to mask the parameter value whenever anyone makes a call that describes the stack. If you set the value
     * to true, the parameter value is masked with asterisks (*****).
     * </p>
     * 
     * @return Whether to mask the parameter value whenever anyone makes a call that describes the stack. If you set the
     *         value to true, the parameter value is masked with asterisks (*****).
     */
    public Boolean noEcho() {
        return noEcho;
    }

    /**
     * Returns true if the ReferencedByResources property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasReferencedByResources() {
        return referencedByResources != null && !(referencedByResources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS SAM resources that use this parameter.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReferencedByResources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of AWS SAM resources that use this parameter.
     */
    public List<String> referencedByResources() {
        return referencedByResources;
    }

    /**
     * <p>
     * The type of the parameter.
     * </p>
     * <p>
     * Valid values: String | Number | List&lt;Number> | CommaDelimitedList
     * </p>
     * <p>
     * String: A literal string.
     * </p>
     * <p>
     * For example, users can specify "MyUserName".
     * </p>
     * <p>
     * Number: An integer or float. AWS CloudFormation validates the parameter value as a number. However, when you use
     * the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the parameter value
     * becomes a string.
     * </p>
     * <p>
     * For example, users might specify "8888".
     * </p>
     * <p>
     * List&lt;Number>: An array of integers or floats that are separated by commas. AWS CloudFormation validates the
     * parameter value as numbers. However, when you use the parameter elsewhere in your template (for example, by using
     * the Ref intrinsic function), the parameter value becomes a list of strings.
     * </p>
     * <p>
     * For example, users might specify "80,20", and then Ref results in ["80","20"].
     * </p>
     * <p>
     * CommaDelimitedList: An array of literal strings that are separated by commas. The total number of strings should
     * be one more than the total number of commas. Also, each member string is space-trimmed.
     * </p>
     * <p>
     * For example, users might specify "test,dev,prod", and then Ref results in ["test","dev","prod"].
     * </p>
     * 
     * @return The type of the parameter.</p>
     *         <p>
     *         Valid values: String | Number | List&lt;Number> | CommaDelimitedList
     *         </p>
     *         <p>
     *         String: A literal string.
     *         </p>
     *         <p>
     *         For example, users can specify "MyUserName".
     *         </p>
     *         <p>
     *         Number: An integer or float. AWS CloudFormation validates the parameter value as a number. However, when
     *         you use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the
     *         parameter value becomes a string.
     *         </p>
     *         <p>
     *         For example, users might specify "8888".
     *         </p>
     *         <p>
     *         List&lt;Number>: An array of integers or floats that are separated by commas. AWS CloudFormation
     *         validates the parameter value as numbers. However, when you use the parameter elsewhere in your template
     *         (for example, by using the Ref intrinsic function), the parameter value becomes a list of strings.
     *         </p>
     *         <p>
     *         For example, users might specify "80,20", and then Ref results in ["80","20"].
     *         </p>
     *         <p>
     *         CommaDelimitedList: An array of literal strings that are separated by commas. The total number of strings
     *         should be one more than the total number of commas. Also, each member string is space-trimmed.
     *         </p>
     *         <p>
     *         For example, users might specify "test,dev,prod", and then Ref results in ["test","dev","prod"].
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(allowedPattern());
        hashCode = 31 * hashCode + Objects.hashCode(allowedValues());
        hashCode = 31 * hashCode + Objects.hashCode(constraintDescription());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(maxLength());
        hashCode = 31 * hashCode + Objects.hashCode(maxValue());
        hashCode = 31 * hashCode + Objects.hashCode(minLength());
        hashCode = 31 * hashCode + Objects.hashCode(minValue());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(noEcho());
        hashCode = 31 * hashCode + Objects.hashCode(referencedByResources());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParameterDefinition)) {
            return false;
        }
        ParameterDefinition other = (ParameterDefinition) obj;
        return Objects.equals(allowedPattern(), other.allowedPattern()) && Objects.equals(allowedValues(), other.allowedValues())
                && Objects.equals(constraintDescription(), other.constraintDescription())
                && Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(description(), other.description())
                && Objects.equals(maxLength(), other.maxLength()) && Objects.equals(maxValue(), other.maxValue())
                && Objects.equals(minLength(), other.minLength()) && Objects.equals(minValue(), other.minValue())
                && Objects.equals(name(), other.name()) && Objects.equals(noEcho(), other.noEcho())
                && Objects.equals(referencedByResources(), other.referencedByResources()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ParameterDefinition").add("AllowedPattern", allowedPattern())
                .add("AllowedValues", allowedValues()).add("ConstraintDescription", constraintDescription())
                .add("DefaultValue", defaultValue()).add("Description", description()).add("MaxLength", maxLength())
                .add("MaxValue", maxValue()).add("MinLength", minLength()).add("MinValue", minValue()).add("Name", name())
                .add("NoEcho", noEcho()).add("ReferencedByResources", referencedByResources()).add("Type", type()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AllowedPattern":
            return Optional.ofNullable(clazz.cast(allowedPattern()));
        case "AllowedValues":
            return Optional.ofNullable(clazz.cast(allowedValues()));
        case "ConstraintDescription":
            return Optional.ofNullable(clazz.cast(constraintDescription()));
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "MaxLength":
            return Optional.ofNullable(clazz.cast(maxLength()));
        case "MaxValue":
            return Optional.ofNullable(clazz.cast(maxValue()));
        case "MinLength":
            return Optional.ofNullable(clazz.cast(minLength()));
        case "MinValue":
            return Optional.ofNullable(clazz.cast(minValue()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "NoEcho":
            return Optional.ofNullable(clazz.cast(noEcho()));
        case "ReferencedByResources":
            return Optional.ofNullable(clazz.cast(referencedByResources()));
        case "Type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParameterDefinition, T> g) {
        return obj -> g.apply((ParameterDefinition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParameterDefinition> {
        /**
         * <p>
         * A regular expression that represents the patterns to allow for String types.
         * </p>
         * 
         * @param allowedPattern
         *        A regular expression that represents the patterns to allow for String types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedPattern(String allowedPattern);

        /**
         * <p>
         * An array containing the list of values allowed for the parameter.
         * </p>
         * 
         * @param allowedValues
         *        An array containing the list of values allowed for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(Collection<String> allowedValues);

        /**
         * <p>
         * An array containing the list of values allowed for the parameter.
         * </p>
         * 
         * @param allowedValues
         *        An array containing the list of values allowed for the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedValues(String... allowedValues);

        /**
         * <p>
         * A string that explains a constraint when the constraint is violated. For example, without a constraint
         * description, a parameter that has an allowed pattern of [A-Za-z0-9]+ displays the following error message
         * when the user specifies an invalid value:
         * </p>
         * <p>
         * Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+
         * </p>
         * <p>
         * By adding a constraint description, such as "must contain only uppercase and lowercase letters and numbers,"
         * you can display the following customized error message:
         * </p>
         * <p>
         * Malformed input-Parameter MyParameter must contain only uppercase and lowercase letters and numbers.
         * </p>
         * 
         * @param constraintDescription
         *        A string that explains a constraint when the constraint is violated. For example, without a constraint
         *        description, a parameter that has an allowed pattern of [A-Za-z0-9]+ displays the following error
         *        message when the user specifies an invalid value:</p>
         *        <p>
         *        Malformed input-Parameter MyParameter must match pattern [A-Za-z0-9]+
         *        </p>
         *        <p>
         *        By adding a constraint description, such as
         *        "must contain only uppercase and lowercase letters and numbers," you can display the following
         *        customized error message:
         *        </p>
         *        <p>
         *        Malformed input-Parameter MyParameter must contain only uppercase and lowercase letters and numbers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder constraintDescription(String constraintDescription);

        /**
         * <p>
         * A value of the appropriate type for the template to use if no value is specified when a stack is created. If
         * you define constraints for the parameter, you must specify a value that adheres to those constraints.
         * </p>
         * 
         * @param defaultValue
         *        A value of the appropriate type for the template to use if no value is specified when a stack is
         *        created. If you define constraints for the parameter, you must specify a value that adheres to those
         *        constraints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * <p>
         * A string of up to 4,000 characters that describes the parameter.
         * </p>
         * 
         * @param description
         *        A string of up to 4,000 characters that describes the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An integer value that determines the largest number of characters that you want to allow for String types.
         * </p>
         * 
         * @param maxLength
         *        An integer value that determines the largest number of characters that you want to allow for String
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxLength(Integer maxLength);

        /**
         * <p>
         * A numeric value that determines the largest numeric value that you want to allow for Number types.
         * </p>
         * 
         * @param maxValue
         *        A numeric value that determines the largest numeric value that you want to allow for Number types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxValue(Integer maxValue);

        /**
         * <p>
         * An integer value that determines the smallest number of characters that you want to allow for String types.
         * </p>
         * 
         * @param minLength
         *        An integer value that determines the smallest number of characters that you want to allow for String
         *        types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minLength(Integer minLength);

        /**
         * <p>
         * A numeric value that determines the smallest numeric value that you want to allow for Number types.
         * </p>
         * 
         * @param minValue
         *        A numeric value that determines the smallest numeric value that you want to allow for Number types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minValue(Integer minValue);

        /**
         * <p>
         * The name of the parameter.
         * </p>
         * 
         * @param name
         *        The name of the parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Whether to mask the parameter value whenever anyone makes a call that describes the stack. If you set the
         * value to true, the parameter value is masked with asterisks (*****).
         * </p>
         * 
         * @param noEcho
         *        Whether to mask the parameter value whenever anyone makes a call that describes the stack. If you set
         *        the value to true, the parameter value is masked with asterisks (*****).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder noEcho(Boolean noEcho);

        /**
         * <p>
         * A list of AWS SAM resources that use this parameter.
         * </p>
         * 
         * @param referencedByResources
         *        A list of AWS SAM resources that use this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencedByResources(Collection<String> referencedByResources);

        /**
         * <p>
         * A list of AWS SAM resources that use this parameter.
         * </p>
         * 
         * @param referencedByResources
         *        A list of AWS SAM resources that use this parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referencedByResources(String... referencedByResources);

        /**
         * <p>
         * The type of the parameter.
         * </p>
         * <p>
         * Valid values: String | Number | List&lt;Number> | CommaDelimitedList
         * </p>
         * <p>
         * String: A literal string.
         * </p>
         * <p>
         * For example, users can specify "MyUserName".
         * </p>
         * <p>
         * Number: An integer or float. AWS CloudFormation validates the parameter value as a number. However, when you
         * use the parameter elsewhere in your template (for example, by using the Ref intrinsic function), the
         * parameter value becomes a string.
         * </p>
         * <p>
         * For example, users might specify "8888".
         * </p>
         * <p>
         * List&lt;Number>: An array of integers or floats that are separated by commas. AWS CloudFormation validates
         * the parameter value as numbers. However, when you use the parameter elsewhere in your template (for example,
         * by using the Ref intrinsic function), the parameter value becomes a list of strings.
         * </p>
         * <p>
         * For example, users might specify "80,20", and then Ref results in ["80","20"].
         * </p>
         * <p>
         * CommaDelimitedList: An array of literal strings that are separated by commas. The total number of strings
         * should be one more than the total number of commas. Also, each member string is space-trimmed.
         * </p>
         * <p>
         * For example, users might specify "test,dev,prod", and then Ref results in ["test","dev","prod"].
         * </p>
         * 
         * @param type
         *        The type of the parameter.</p>
         *        <p>
         *        Valid values: String | Number | List&lt;Number> | CommaDelimitedList
         *        </p>
         *        <p>
         *        String: A literal string.
         *        </p>
         *        <p>
         *        For example, users can specify "MyUserName".
         *        </p>
         *        <p>
         *        Number: An integer or float. AWS CloudFormation validates the parameter value as a number. However,
         *        when you use the parameter elsewhere in your template (for example, by using the Ref intrinsic
         *        function), the parameter value becomes a string.
         *        </p>
         *        <p>
         *        For example, users might specify "8888".
         *        </p>
         *        <p>
         *        List&lt;Number>: An array of integers or floats that are separated by commas. AWS CloudFormation
         *        validates the parameter value as numbers. However, when you use the parameter elsewhere in your
         *        template (for example, by using the Ref intrinsic function), the parameter value becomes a list of
         *        strings.
         *        </p>
         *        <p>
         *        For example, users might specify "80,20", and then Ref results in ["80","20"].
         *        </p>
         *        <p>
         *        CommaDelimitedList: An array of literal strings that are separated by commas. The total number of
         *        strings should be one more than the total number of commas. Also, each member string is space-trimmed.
         *        </p>
         *        <p>
         *        For example, users might specify "test,dev,prod", and then Ref results in ["test","dev","prod"].
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String allowedPattern;

        private List<String> allowedValues = DefaultSdkAutoConstructList.getInstance();

        private String constraintDescription;

        private String defaultValue;

        private String description;

        private Integer maxLength;

        private Integer maxValue;

        private Integer minLength;

        private Integer minValue;

        private String name;

        private Boolean noEcho;

        private List<String> referencedByResources = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ParameterDefinition model) {
            allowedPattern(model.allowedPattern);
            allowedValues(model.allowedValues);
            constraintDescription(model.constraintDescription);
            defaultValue(model.defaultValue);
            description(model.description);
            maxLength(model.maxLength);
            maxValue(model.maxValue);
            minLength(model.minLength);
            minValue(model.minValue);
            name(model.name);
            noEcho(model.noEcho);
            referencedByResources(model.referencedByResources);
            type(model.type);
        }

        public final String getAllowedPattern() {
            return allowedPattern;
        }

        @Override
        public final Builder allowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
            return this;
        }

        public final void setAllowedPattern(String allowedPattern) {
            this.allowedPattern = allowedPattern;
        }

        public final Collection<String> getAllowedValues() {
            return allowedValues;
        }

        @Override
        public final Builder allowedValues(Collection<String> allowedValues) {
            this.allowedValues = ___listOf__stringCopier.copy(allowedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedValues(String... allowedValues) {
            allowedValues(Arrays.asList(allowedValues));
            return this;
        }

        public final void setAllowedValues(Collection<String> allowedValues) {
            this.allowedValues = ___listOf__stringCopier.copy(allowedValues);
        }

        public final String getConstraintDescription() {
            return constraintDescription;
        }

        @Override
        public final Builder constraintDescription(String constraintDescription) {
            this.constraintDescription = constraintDescription;
            return this;
        }

        public final void setConstraintDescription(String constraintDescription) {
            this.constraintDescription = constraintDescription;
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Integer getMaxLength() {
            return maxLength;
        }

        @Override
        public final Builder maxLength(Integer maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public final void setMaxLength(Integer maxLength) {
            this.maxLength = maxLength;
        }

        public final Integer getMaxValue() {
            return maxValue;
        }

        @Override
        public final Builder maxValue(Integer maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final void setMaxValue(Integer maxValue) {
            this.maxValue = maxValue;
        }

        public final Integer getMinLength() {
            return minLength;
        }

        @Override
        public final Builder minLength(Integer minLength) {
            this.minLength = minLength;
            return this;
        }

        public final void setMinLength(Integer minLength) {
            this.minLength = minLength;
        }

        public final Integer getMinValue() {
            return minValue;
        }

        @Override
        public final Builder minValue(Integer minValue) {
            this.minValue = minValue;
            return this;
        }

        public final void setMinValue(Integer minValue) {
            this.minValue = minValue;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Boolean getNoEcho() {
            return noEcho;
        }

        @Override
        public final Builder noEcho(Boolean noEcho) {
            this.noEcho = noEcho;
            return this;
        }

        public final void setNoEcho(Boolean noEcho) {
            this.noEcho = noEcho;
        }

        public final Collection<String> getReferencedByResources() {
            return referencedByResources;
        }

        @Override
        public final Builder referencedByResources(Collection<String> referencedByResources) {
            this.referencedByResources = ___listOf__stringCopier.copy(referencedByResources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referencedByResources(String... referencedByResources) {
            referencedByResources(Arrays.asList(referencedByResources));
            return this;
        }

        public final void setReferencedByResources(Collection<String> referencedByResources) {
            this.referencedByResources = ___listOf__stringCopier.copy(referencedByResources);
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public ParameterDefinition build() {
            return new ParameterDefinition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
