/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.servicequotas.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListServicesResponse extends ServiceQuotasResponse implements
        ToCopyableBuilder<ListServicesResponse.Builder, ListServicesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListServicesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ServiceInfo>> SERVICES_FIELD = SdkField
            .<List<ServiceInfo>> builder(MarshallingType.LIST)
            .memberName("Services")
            .getter(getter(ListServicesResponse::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ServiceInfo> builder(MarshallingType.SDK_POJO)
                                            .constructor(ServiceInfo::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SERVICES_FIELD));

    private final String nextToken;

    private final List<ServiceInfo> services;

    private ListServicesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.services = builder.services;
    }

    /**
     * <p>
     * If present in the response, this value indicates there's more output available that what's included in the
     * current response. This can occur even when the response includes no values at all, such as when you ask for a
     * filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a subsequent
     * call to the operation to continue processing and get the next part of the output. You should repeat this until
     * the <code>NextToken</code> response element comes back empty (as <code>null</code>).
     * </p>
     * 
     * @return If present in the response, this value indicates there's more output available that what's included in
     *         the current response. This can occur even when the response includes no values at all, such as when you
     *         ask for a filtered view of a very long list. Use this value in the <code>NextToken</code> request
     *         parameter in a subsequent call to the operation to continue processing and get the next part of the
     *         output. You should repeat this until the <code>NextToken</code> response element comes back empty (as
     *         <code>null</code>).
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * Returns true if the Services property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Returns a list of services.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasServices()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Returns a list of services.
     */
    public List<ServiceInfo> services() {
        return services;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(services());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesResponse)) {
            return false;
        }
        ListServicesResponse other = (ListServicesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && Objects.equals(services(), other.services());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListServicesResponse").add("NextToken", nextToken()).add("Services", services()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Services":
            return Optional.ofNullable(clazz.cast(services()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesResponse, T> g) {
        return obj -> g.apply((ListServicesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ServiceQuotasResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListServicesResponse> {
        /**
         * <p>
         * If present in the response, this value indicates there's more output available that what's included in the
         * current response. This can occur even when the response includes no values at all, such as when you ask for a
         * filtered view of a very long list. Use this value in the <code>NextToken</code> request parameter in a
         * subsequent call to the operation to continue processing and get the next part of the output. You should
         * repeat this until the <code>NextToken</code> response element comes back empty (as <code>null</code>).
         * </p>
         * 
         * @param nextToken
         *        If present in the response, this value indicates there's more output available that what's included in
         *        the current response. This can occur even when the response includes no values at all, such as when
         *        you ask for a filtered view of a very long list. Use this value in the <code>NextToken</code> request
         *        parameter in a subsequent call to the operation to continue processing and get the next part of the
         *        output. You should repeat this until the <code>NextToken</code> response element comes back empty (as
         *        <code>null</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Returns a list of services.
         * </p>
         * 
         * @param services
         *        Returns a list of services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<ServiceInfo> services);

        /**
         * <p>
         * Returns a list of services.
         * </p>
         * 
         * @param services
         *        Returns a list of services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(ServiceInfo... services);

        /**
         * <p>
         * Returns a list of services.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ServiceInfo>.Builder} avoiding the need to
         * create one manually via {@link List<ServiceInfo>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ServiceInfo>.Builder#build()} is called immediately and its
         * result is passed to {@link #services(List<ServiceInfo>)}.
         * 
         * @param services
         *        a consumer that will call methods on {@link List<ServiceInfo>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(List<ServiceInfo>)
         */
        Builder services(Consumer<ServiceInfo.Builder>... services);
    }

    static final class BuilderImpl extends ServiceQuotasResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ServiceInfo> services = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesResponse model) {
            super(model);
            nextToken(model.nextToken);
            services(model.services);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ServiceInfo.Builder> getServices() {
            return services != null ? services.stream().map(ServiceInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder services(Collection<ServiceInfo> services) {
            this.services = ServiceInfoListDefinitionCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(ServiceInfo... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<ServiceInfo.Builder>... services) {
            services(Stream.of(services).map(c -> ServiceInfo.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setServices(Collection<ServiceInfo.BuilderImpl> services) {
            this.services = ServiceInfoListDefinitionCopier.copyFromBuilder(services);
        }

        @Override
        public ListServicesResponse build() {
            return new ListServicesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
