/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.descriptors;

import java.util.EventObject;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.ObjectChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.essentials.sessions.Record;

public class DescriptorEvent
extends EventObject {
    protected int eventCode;
    protected DatabaseQuery query;
    protected Record record;
    protected ClassDescriptor descriptor;
    protected Object originalObject;
    protected ObjectChangeSet changeSet;
    protected AbstractSession session;
    protected static String[] eventNames = new String[18];

    public DescriptorEvent(int eventCode, ObjectLevelModifyQuery query) {
        this(query.getObject());
        this.query = query;
        this.eventCode = eventCode;
        this.session = query.getSession();
        this.descriptor = query.getDescriptor();
    }

    public DescriptorEvent(Object sourceObject) {
        super(sourceObject);
    }

    public void applyAttributeValuesIntoRow(String attributeName) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(this.getSource());
        DatabaseMapping mapping = descriptor.getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw ValidationException.missingMappingForAttribute(descriptor, attributeName, this.toString());
        }
        if (this.getRecord() != null) {
            mapping.writeFromObjectIntoRow(this.getSource(), (AbstractRecord)this.getRecord(), this.getSession());
        }
    }

    public ObjectChangeSet getChangeSet() {
        return this.changeSet;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public ClassDescriptor getClassDescriptor() {
        ClassDescriptor desc = this.getDescriptor();
        if (desc instanceof ClassDescriptor) {
            return desc;
        }
        throw ValidationException.cannotCastToClass(desc, desc.getClass(), ClassDescriptor.class);
    }

    public int getEventCode() {
        return this.eventCode;
    }

    public Object getObject() {
        return this.getSource();
    }

    public Object getOriginalObject() {
        if (this.originalObject == null && this.getSession().isUnitOfWork() && this.getQuery() != null && this.getQuery().isObjectLevelModifyQuery()) {
            this.setOriginalObject(((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(this.getSource()));
        }
        return this.originalObject;
    }

    public DatabaseQuery getQuery() {
        return this.query;
    }

    public Record getRecord() {
        return this.record;
    }

    public AbstractSession getSession() {
        return this.session;
    }

    public void setChangeSet(ObjectChangeSet newChangeSet) {
        this.changeSet = newChangeSet;
    }

    public void setDescriptor(ClassDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void setEventCode(int eventCode) {
        this.eventCode = eventCode;
    }

    public void setOriginalObject(Object originalObject) {
        this.originalObject = originalObject;
    }

    public void setQuery(DatabaseQuery query) {
        this.query = query;
    }

    public void setRecord(Record record) {
        this.record = record;
    }

    public void setSession(AbstractSession session) {
        this.session = session;
    }

    public String toString() {
        String eventName = "UnkownEvent";
        if (this.getEventCode() >= 0 && this.getEventCode() < 18) {
            eventName = eventNames[this.getEventCode()];
        }
        return eventName + "(" + this.getSource().getClass() + ")";
    }

    public void updateAttributeWithObject(String attributeName, Object value) {
        ClassDescriptor descriptor;
        DatabaseMapping mapping = this.query.getDescriptor().getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(attributeName, this.getDescriptor());
        }
        Object clone = this.getObject();
        Object cloneValue = value;
        Object original = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            original = this.getOriginalObject();
        }
        Object originalValue = value;
        ObjectChangeSet eventChangeSet = this.getChangeSet();
        Object valueForChangeSet = value;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            clone = ((ObjectLevelModifyQuery)this.query).getObject();
            eventChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((descriptor = this.getSession().getDescriptor(value.getClass())) != null) {
            if (eventChangeSet != null) {
                valueForChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(value, (UnitOfWorkChangeSet)eventChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (original != null) {
                originalValue = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(value);
            }
        }
        if (clone != null) {
            mapping.setRealAttributeValueInObject(clone, cloneValue);
        }
        if (original != null) {
            mapping.setRealAttributeValueInObject(original, originalValue);
        }
        if (this.getRecord() != null) {
            AbstractRecord tempRow = this.getDescriptor().getObjectBuilder().createRecord();
            mapping.writeFromObjectIntoRow(clone, tempRow, this.getSession());
            ((AbstractRecord)this.getRecord()).mergeFrom(tempRow);
        }
        if (eventChangeSet != null) {
            eventChangeSet.removeChange(attributeName);
            eventChangeSet.addChange(mapping.compareForChange(clone, ((UnitOfWorkImpl)this.getSession()).getBackupClone(clone), eventChangeSet, this.getSession()));
        }
    }

    public void updateAttributeAddObjectToCollection(String attributeName, Object mapKey, Object value) {
        Object collection;
        ClassDescriptor descriptor;
        DatabaseMapping mapping = this.query.getDescriptor().getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(attributeName, this.getDescriptor());
        }
        Object clone = this.getObject();
        Object cloneValue = value;
        Object original = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            original = this.getOriginalObject();
        }
        Object originalValue = value;
        ObjectChangeSet eventChangeSet = this.getChangeSet();
        Object valueForChangeSet = value;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            clone = ((ObjectLevelModifyQuery)this.query).getObject();
            eventChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((descriptor = this.getSession().getDescriptor(value.getClass())) != null) {
            if (eventChangeSet != null) {
                valueForChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(value, (UnitOfWorkChangeSet)eventChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (original != null) {
                originalValue = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(value);
            }
        }
        if (clone != null) {
            collection = mapping.getRealCollectionAttributeValueFromObject(clone, this.getSession());
            mapping.getContainerPolicy().addInto(mapKey, cloneValue, collection, this.getSession());
        }
        if (original != null) {
            collection = mapping.getRealCollectionAttributeValueFromObject(original, this.getSession());
            mapping.getContainerPolicy().addInto(mapKey, originalValue, collection, this.getSession());
        }
        if (this.getRecord() != null) {
            AbstractRecord tempRow = this.getDescriptor().getObjectBuilder().createRecord();
            mapping.writeFromObjectIntoRow(clone, tempRow, this.getSession());
            ((AbstractRecord)this.getRecord()).mergeFrom(tempRow);
        }
        if (eventChangeSet != null) {
            mapping.simpleAddToCollectionChangeRecord(mapKey, valueForChangeSet, eventChangeSet, this.getSession());
        }
    }

    public void updateAttributeRemoveObjectFromCollection(String attributeName, Object mapKey, Object value) {
        Object collection;
        ClassDescriptor descriptor;
        DatabaseMapping mapping = this.query.getDescriptor().getMappingForAttributeName(attributeName);
        if (mapping == null) {
            throw DescriptorException.mappingForAttributeIsMissing(attributeName, this.getDescriptor());
        }
        Object clone = this.getObject();
        Object cloneValue = value;
        Object original = null;
        if (this.eventCode == 10 || this.eventCode == 11) {
            original = this.getOriginalObject();
        }
        Object originalValue = value;
        ObjectChangeSet eventChangeSet = this.getChangeSet();
        Object valueForChangeSet = value;
        if (this.query != null && this.query.isObjectLevelModifyQuery()) {
            clone = ((ObjectLevelModifyQuery)this.query).getObject();
            eventChangeSet = ((ObjectLevelModifyQuery)this.query).getObjectChangeSet();
        }
        if ((descriptor = this.getSession().getDescriptor(value.getClass())) != null) {
            if (eventChangeSet != null) {
                valueForChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(value, (UnitOfWorkChangeSet)eventChangeSet.getUOWChangeSet(), this.getSession());
            }
            if (original != null) {
                originalValue = ((UnitOfWorkImpl)this.getSession()).getOriginalVersionOfObject(value);
            }
        }
        if (clone != null) {
            collection = mapping.getRealCollectionAttributeValueFromObject(clone, this.getSession());
            mapping.getContainerPolicy().removeFrom(mapKey, cloneValue, collection, this.getSession());
        }
        if (original != null) {
            collection = mapping.getRealCollectionAttributeValueFromObject(original, this.getSession());
            mapping.getContainerPolicy().removeFrom(mapKey, originalValue, collection, this.getSession());
        }
        if (this.getRecord() != null) {
            AbstractRecord tempRow = this.getDescriptor().getObjectBuilder().createRecord();
            mapping.writeFromObjectIntoRow(clone, tempRow, this.getSession());
            ((AbstractRecord)this.getRecord()).mergeFrom(tempRow);
        }
        if (eventChangeSet != null) {
            mapping.simpleRemoveFromCollectionChangeRecord(mapKey, valueForChangeSet, eventChangeSet, this.getSession());
        }
    }

    static {
        DescriptorEvent.eventNames[0] = "PreWriteEvent";
        DescriptorEvent.eventNames[1] = "PostWriteEvent";
        DescriptorEvent.eventNames[2] = "PostDeleteEvent";
        DescriptorEvent.eventNames[3] = "PostDeleteEvent";
        DescriptorEvent.eventNames[4] = "PreInsertEvent";
        DescriptorEvent.eventNames[5] = "PostInsertEvent";
        DescriptorEvent.eventNames[6] = "PreUpdateEvent";
        DescriptorEvent.eventNames[7] = "PostUpdateEvent";
        DescriptorEvent.eventNames[8] = "PostBuildEvent";
        DescriptorEvent.eventNames[9] = "PostRefreshEvent";
        DescriptorEvent.eventNames[10] = "PostCloneEvent";
        DescriptorEvent.eventNames[11] = "PostMergeEvent";
        DescriptorEvent.eventNames[12] = "AboutToInsertEvent";
        DescriptorEvent.eventNames[13] = "AboutToUpdateEvent";
    }
}

