/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.exceptions;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.IntegrityChecker;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.exceptions.i18n.ExceptionMessageGenerator;
import oracle.toplink.essentials.internal.helper.Helper;

public class IntegrityException
extends ValidationException {
    protected IntegrityChecker integrityChecker;

    public IntegrityException() {
    }

    public IntegrityException(IntegrityChecker integrityChecker) {
        this.integrityChecker = integrityChecker;
    }

    public IntegrityChecker getIntegrityChecker() {
        return this.integrityChecker;
    }

    public String getMessage() {
        Exception e;
        String cr = Helper.cr();
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println(cr + ExceptionMessageGenerator.getHeader("DescriptorExceptionsHeader"));
        writer.println("---------------------------------------------------------");
        Enumeration enumtr = this.getIntegrityChecker().getCaughtExceptions().elements();
        while (enumtr.hasMoreElements()) {
            e = (Exception)enumtr.nextElement();
            if (!(e instanceof DescriptorException)) continue;
            writer.println(cr + e);
        }
        if (this.getIntegrityChecker().hasRuntimeExceptions()) {
            writer.println(cr + ExceptionMessageGenerator.getHeader("RuntimeExceptionsHeader"));
            writer.println("---------------------------------------------------------");
            enumtr = this.getIntegrityChecker().getCaughtExceptions().elements();
            while (enumtr.hasMoreElements()) {
                e = (Exception)enumtr.nextElement();
                if (e instanceof DescriptorException) continue;
                writer.println(cr + e);
            }
        }
        writer.flush();
        swriter.flush();
        return swriter.toString();
    }

    public void printStackTrace(PrintWriter writer) {
        Exception e;
        super.printStackTrace(writer);
        String cr = Helper.cr();
        writer.println(cr + ExceptionMessageGenerator.getHeader("DescriptorExceptionsHeader"));
        writer.println("---------------------------------------------------------");
        Enumeration enumtr = this.getIntegrityChecker().getCaughtExceptions().elements();
        while (enumtr.hasMoreElements()) {
            e = (Exception)enumtr.nextElement();
            if (!(e instanceof DescriptorException)) continue;
            writer.println(cr);
            e.printStackTrace(writer);
        }
        if (this.getIntegrityChecker().hasRuntimeExceptions()) {
            writer.println(cr + ExceptionMessageGenerator.getHeader("RuntimeExceptionsHeader"));
            writer.println("---------------------------------------------------------");
            enumtr = this.getIntegrityChecker().getCaughtExceptions().elements();
            while (enumtr.hasMoreElements()) {
                e = (Exception)enumtr.nextElement();
                if (e instanceof DescriptorException) continue;
                writer.println(cr);
                e.printStackTrace(writer);
            }
        }
        writer.flush();
    }
}

