/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors;

import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.BasicAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.columns.MetadataColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.XMLHelper;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.accessors.XMLClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.columns.XMLColumn;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.XMLGeneratedValue;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.XMLSequenceGenerator;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.sequencing.XMLTableGenerator;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import org.w3c.dom.Node;

public class XMLBasicAccessor
extends BasicAccessor
implements XMLAccessor {
    private Node m_node;
    private XMLHelper m_helper;

    public XMLBasicAccessor(MetadataAccessibleObject accessibleObject, Node node, XMLClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
        this.m_node = node;
        this.m_helper = classAccessor.getHelper();
    }

    public String getCatalog() {
        return this.m_descriptor.getCatalog();
    }

    protected MetadataColumn getColumn(String loggingCtx) {
        Node node = this.m_helper.getNode(this.m_node, "column");
        if (node != null) {
            return new XMLColumn(node, this.m_helper, this);
        }
        return super.getColumn(loggingCtx);
    }

    public String getDocumentName() {
        return this.m_helper.getDocumentName();
    }

    public String getEnumeratedType() {
        if (this.hasEnumerated()) {
            return this.m_helper.getNodeTextValue(this.m_node, "enumerated");
        }
        return super.getEnumeratedType();
    }

    public String getFetchType() {
        return this.m_helper.getFetchTypeDefaultEAGER(this.m_node);
    }

    public XMLHelper getHelper() {
        return this.m_helper;
    }

    public String getSchema() {
        return this.m_descriptor.getSchema();
    }

    public String getTemporalType() {
        if (this.hasTemporal()) {
            return this.m_helper.getNodeTextValue(this.m_node, "temporal");
        }
        return super.getTemporalType();
    }

    public boolean hasEnumerated() {
        Node node = this.m_helper.getNode(this.m_node, "enumerated");
        if (node == null) {
            return super.hasEnumerated();
        }
        return true;
    }

    public boolean hasTemporal() {
        Node node = this.m_helper.getNode(this.m_node, "temporal");
        if (node == null) {
            return super.hasTemporal();
        }
        return true;
    }

    public boolean isId() {
        if (this.m_node.getLocalName().equals("id")) {
            return true;
        }
        return super.isId();
    }

    public boolean isOptional() {
        return this.m_helper.isOptional(this.m_node);
    }

    public boolean hasLob() {
        Node node = this.m_helper.getNode(this.m_node, "lob");
        if (node == null) {
            return super.hasLob();
        }
        return true;
    }

    public boolean isVersion() {
        if (this.m_node.getLocalName().equals("version")) {
            return true;
        }
        return super.isVersion();
    }

    protected void processGeneratedValue(DatabaseField field) {
        Node node = this.m_helper.getNode(this.m_node, "generated-value");
        if (node == null) {
            super.processGeneratedValue(field);
        } else {
            this.processGeneratedValue(new XMLGeneratedValue(node, this.m_helper), field);
        }
    }

    protected void processSequenceGenerator() {
        Node node = this.m_helper.getNode(this.m_node, "sequence-generator");
        if (node != null) {
            this.processSequenceGenerator(new XMLSequenceGenerator(node, this.m_helper));
        }
        super.processSequenceGenerator();
    }

    protected void processTableGenerator() {
        Node node = this.m_helper.getNode(this.m_node, "table-generator");
        if (node != null) {
            this.processTableGenerator(new XMLTableGenerator(node, this));
        }
        super.processTableGenerator();
    }
}

