/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.databaseaccess.DatabaseCall;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.SQLModifyStatement;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;

public class SQLUpdateAllStatement
extends SQLModifyStatement {
    protected HashMap m_updateClauses;
    protected HashMap databaseFieldsToTableAliases;
    protected SQLCall selectCallForExist;
    protected String tableAliasInSelectCallForExist;
    protected Collection primaryKeyFields;
    protected boolean shouldExtractWhereClauseFromSelectCallForExist;

    public void setSelectCallForExist(SQLCall selectCallForExist) {
        this.selectCallForExist = selectCallForExist;
    }

    public SQLCall getSelectCallForExist() {
        return this.selectCallForExist;
    }

    public void setTableAliasInSelectCallForExist(String tableAliasInSelectCallForExist) {
        this.tableAliasInSelectCallForExist = tableAliasInSelectCallForExist;
    }

    public String getTableAliasInSelectCallForExist() {
        return this.tableAliasInSelectCallForExist;
    }

    public void setPrimaryKeyFieldsForAutoJoin(Collection primaryKeyFields) {
        this.primaryKeyFields = primaryKeyFields;
    }

    public Collection getPrimaryKeyFieldsForAutoJoin() {
        return this.primaryKeyFields;
    }

    public void setUpdateClauses(HashMap updateClauses) {
        this.m_updateClauses = updateClauses;
    }

    public HashMap getUpdateClauses() {
        return this.m_updateClauses;
    }

    public void setDatabaseFieldsToTableAliases(HashMap databaseFieldsToTableAliases) {
        this.databaseFieldsToTableAliases = databaseFieldsToTableAliases;
    }

    public HashMap getDatabaseFieldsToTableAliases() {
        return this.databaseFieldsToTableAliases;
    }

    public void setShouldExtractWhereClauseFromSelectCallForExist(boolean shouldExtractWhereClauseFromSelectCallForExist) {
        this.shouldExtractWhereClauseFromSelectCallForExist = shouldExtractWhereClauseFromSelectCallForExist;
    }

    public boolean shouldExtractWhereClauseFromSelectCallForExist() {
        return this.shouldExtractWhereClauseFromSelectCallForExist;
    }

    public DatabaseCall buildCall(AbstractSession session) {
        SQLCall call = this.buildSimple(session);
        if (this.selectCallForExist == null) {
            return call;
        }
        CharArrayWriter writer = new CharArrayWriter(100);
        try {
            writer.write(call.getSQLString());
            if (this.selectCallForExist != null) {
                if (this.shouldExtractWhereClauseFromSelectCallForExist) {
                    this.writeWhere(writer, this.selectCallForExist, call);
                } else {
                    writer.write(" WHERE EXISTS(");
                    this.writeSelect(writer, this.selectCallForExist, this.tableAliasInSelectCallForExist, call);
                    writer.write(")");
                }
            }
            call.setSQLString(((Object)writer).toString());
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
        return call;
    }

    protected SQLCall buildSimple(AbstractSession session) {
        SQLCall call = new SQLCall();
        call.returnNothing();
        CharArrayWriter writer = new CharArrayWriter(100);
        ExpressionSQLPrinter printer = new ExpressionSQLPrinter(session, this.getTranslationRow(), call, false);
        printer.setWriter(writer);
        try {
            writer.write("UPDATE ");
            writer.write(this.getTable().getQualifiedName());
            writer.write(" SET ");
            Iterator i = this.m_updateClauses.keySet().iterator();
            boolean commaNeeded = false;
            while (i.hasNext()) {
                if (commaNeeded) {
                    writer.write(", ");
                }
                DatabaseField field = (DatabaseField)i.next();
                Object value = this.m_updateClauses.get(field);
                writer.write(field.getName());
                writer.write(" = ");
                if (value instanceof Expression) {
                    printer.printExpression((Expression)value);
                } else {
                    SQLCall selCall = (SQLCall)value;
                    String tableAlias = (String)this.getDatabaseFieldsToTableAliases().get(field);
                    writer.write("(");
                    this.writeSelect(writer, selCall, tableAlias, call);
                    writer.write(")");
                }
                commaNeeded = true;
            }
            if (this.getWhereClause() != null) {
                writer.write(" WHERE ");
                printer.printExpression(this.getWhereClause());
            }
            call.setSQLString(((Object)writer).toString());
            return call;
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }

    protected void writeSelect(Writer writer, SQLCall selectCall, String tableAliasInSelectCall, SQLCall call) throws IOException {
        String str = selectCall.getSQLString();
        writer.write(str);
        boolean hasWhereClause = str.toUpperCase().indexOf(" WHERE ") >= 0;
        Iterator it = this.getPrimaryKeyFieldsForAutoJoin().iterator();
        while (it.hasNext()) {
            if (!hasWhereClause) {
                writer.write(" WHERE ");
                hasWhereClause = true;
            } else {
                writer.write(" AND ");
            }
            String fieldName = ((DatabaseField)it.next()).getName();
            if (tableAliasInSelectCall != null) {
                writer.write(tableAliasInSelectCall);
                writer.write(46);
            }
            writer.write(fieldName);
            writer.write(" = ");
            writer.write(this.table.getQualifiedName());
            writer.write(46);
            writer.write(fieldName);
        }
        call.getParameters().addAll(selectCall.getParameters());
        call.getParameterTypes().addAll(selectCall.getParameterTypes());
    }

    protected boolean writeWhere(Writer writer, SQLCall selectCall, SQLCall call) throws IOException {
        String selectStr = this.selectCallForExist.getSQLString();
        int index = selectStr.toUpperCase().indexOf(" WHERE ");
        if (index < 0) {
            return false;
        }
        String str = selectStr.substring(index);
        writer.write(str);
        call.getParameters().addAll(selectCall.getParameters());
        call.getParameterTypes().addAll(selectCall.getParameterTypes());
        return true;
    }
}

