/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.expressions;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.expressions.ExpressionSQLPrinter;
import oracle.toplink.essentials.internal.expressions.SQLModifyStatement;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.SQLCall;

public class SQLUpdateStatement
extends SQLModifyStatement {
    protected SQLCall buildCallWithoutReturning(AbstractSession session) {
        SQLCall call = new SQLCall();
        call.returnNothing();
        CharArrayWriter writer = new CharArrayWriter(100);
        try {
            DatabaseField field;
            writer.write("UPDATE ");
            writer.write(this.getTable().getQualifiedName());
            writer.write(" SET ");
            Vector<DatabaseField> fieldsForTable = new Vector<DatabaseField>();
            Enumeration fieldsEnum = this.getModifyRow().keys();
            while (fieldsEnum.hasMoreElements()) {
                field = (DatabaseField)fieldsEnum.nextElement();
                if (!field.getTable().equals(this.getTable()) && field.hasTableName()) continue;
                fieldsForTable.addElement(field);
            }
            if (fieldsForTable.isEmpty()) {
                return null;
            }
            for (int i = 0; i < fieldsForTable.size(); ++i) {
                field = (DatabaseField)fieldsForTable.elementAt(i);
                writer.write(field.getName());
                writer.write(" = ");
                call.appendModify(writer, field);
                if (i + 1 >= fieldsForTable.size()) continue;
                writer.write(", ");
            }
            if (this.getWhereClause() != null) {
                writer.write(" WHERE ");
                ExpressionSQLPrinter printer = new ExpressionSQLPrinter(session, this.getTranslationRow(), call, false);
                printer.setWriter(writer);
                printer.printExpression(this.getWhereClause());
            }
            call.setSQLString(((Object)writer).toString());
            return call;
        }
        catch (IOException exception) {
            throw ValidationException.fileError(exception);
        }
    }
}

