/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sequencing;

import oracle.toplink.essentials.internal.sequencing.Sequencing;
import oracle.toplink.essentials.internal.sequencing.SequencingServer;
import oracle.toplink.essentials.threetier.ClientSession;

class ClientSessionSequencing
implements Sequencing {
    protected ClientSession clientSession;
    protected SequencingServer sequencingServer;

    public static boolean sequencingServerExists(ClientSession cs) {
        return cs.getParent().getSequencingServer() != null;
    }

    public ClientSessionSequencing(ClientSession clientSession) {
        this.clientSession = clientSession;
        this.sequencingServer = clientSession.getParent().getSequencingServer();
    }

    public boolean shouldAcquireValueAfterInsert(Class cls) {
        return this.sequencingServer.shouldAcquireValueAfterInsert(cls);
    }

    public int whenShouldAcquireValueForAll() {
        return this.sequencingServer.whenShouldAcquireValueForAll();
    }

    public boolean shouldOverrideExistingValue(Class cls, Object existingValue) {
        return this.sequencingServer.shouldOverrideExistingValue(cls, existingValue);
    }

    public Object getNextValue(Class cls) {
        return this.sequencingServer.getNextValue(this.clientSession, cls);
    }
}

