/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.EnumSet;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedClassForName;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.converters.ObjectTypeConverter;
import oracle.toplink.essentials.sessions.Session;

public class EnumTypeConverter
extends ObjectTypeConverter {
    private Class m_enumClass;
    private String m_enumClassName;

    public EnumTypeConverter(DatabaseMapping mapping, Class enumClass, boolean useOrdinalValues) {
        super(mapping);
        this.m_enumClassName = enumClass.getName();
        EnumSet<Enum> theEnums = EnumSet.allOf(enumClass);
        for (Enum theEnum : theEnums) {
            if (useOrdinalValues) {
                this.addConversionValue(theEnum.ordinal(), theEnum.name());
                continue;
            }
            this.addConversionValue(theEnum.name(), theEnum.name());
        }
    }

    public EnumTypeConverter(DatabaseMapping mapping, String enumClassName) {
        super(mapping);
        this.m_enumClassName = enumClassName;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block5: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.m_enumClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.m_enumClassName, true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException exception) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.m_enumClassName, exception.getException());
                    }
                }
                this.m_enumClass = PrivilegedAccessHelper.getClassForName(this.m_enumClassName, true, classLoader);
            }
            catch (ClassNotFoundException exception) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.m_enumClassName, exception);
            }
        }
    }

    public Object convertDataValueToObjectValue(Object fieldValue, Session session) {
        Object obj = super.convertDataValueToObjectValue(fieldValue, session);
        if (fieldValue == null) {
            return obj;
        }
        return Enum.valueOf(this.m_enumClass, (String)obj);
    }

    public Object convertObjectValueToDataValue(Object attributeValue, Session session) {
        if (attributeValue == null) {
            return super.convertObjectValueToDataValue(null, session);
        }
        return super.convertObjectValueToDataValue(((Enum)Enum.class.cast(attributeValue)).name(), session);
    }
}

