/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Hashtable;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.ExpressionOperator;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.essentials.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.queryframework.ValueReadQuery;

public final class SQLAnyWherePlatform
extends DatabasePlatform {
    private static final ExpressionOperator createCurrentDateOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(123, "CURRENT DATE");
    }

    private static final ExpressionOperator createCurrentTimeOperator() {
        return ExpressionOperator.simpleFunctionNoParentheses(124, "CURRENT TIME");
    }

    private static final ExpressionOperator createLocate2Operator() {
        return ExpressionOperator.simpleThreeArgumentFunction(113, "LOCATE");
    }

    private static final ExpressionOperator createLocateOperator() {
        return ExpressionOperator.simpleTwoArgumentFunction(112, "LOCATE");
    }

    private static final ExpressionOperator createConcatOperator() {
        return ExpressionOperator.simpleLogicalNoParens(31, "||");
    }

    protected final Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("BIT", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("REAL", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("DOUBLE", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("DOUBLE", false));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("DOUBLE", false));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR"));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR"));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("LONG BINARY", false));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("LONG VARCHAR", false));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("LONG BINARY", false));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("LONG VARCHAR", false));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("LONG BINARY", false));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("LONG VARCHAR", false));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        return fieldTypeMapping;
    }

    public final ValueReadQuery buildSelectQueryForIdentity() {
        return new ValueReadQuery("SELECT @@identity");
    }

    protected final String getCreateTempTableSqlPrefix() {
        return "DECLARE TEMPORARY TABLE ";
    }

    public final int getJDBCType(Class javaType) {
        return javaType == ClassConstants.BLOB ? -4 : (javaType == ClassConstants.CLOB ? -1 : super.getJDBCType(javaType));
    }

    public final int getMaxFieldNameSize() {
        return 128;
    }

    public final DatabaseTable getTempTableForTable(DatabaseTable table) {
        return new DatabaseTable("$" + table.getName(), table.getTableQualifier());
    }

    protected final void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(SQLAnyWherePlatform.createLocateOperator());
        this.addOperator(SQLAnyWherePlatform.createLocate2Operator());
        this.addOperator(SQLAnyWherePlatform.createCurrentDateOperator());
        this.addOperator(SQLAnyWherePlatform.createCurrentTimeOperator());
        this.addOperator(SQLAnyWherePlatform.createConcatOperator());
        this.addOperator(ExpressionOperator.charLength());
    }

    public final boolean isSQLAnywhere() {
        return true;
    }

    public final void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" DEFAULT AUTOINCREMENT");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public final void printFieldNullClause(Writer writer) throws ValidationException {
        try {
            writer.write(" NULL");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public final boolean supportsLocalTempTables() {
        return true;
    }

    public final boolean supportsIdentity() {
        return true;
    }

    public final boolean supportsStoredFunctions() {
        return true;
    }
}

