/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.queryframework.ContainerPolicy;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.queryframework.Call;
import oracle.toplink.essentials.queryframework.ReadQuery;

public class DataReadQuery
extends ReadQuery {
    protected ContainerPolicy containerPolicy;
    protected boolean useAbstractRecord = true;

    public DataReadQuery() {
        this.shouldMaintainCache = false;
        this.useAbstractRecord = true;
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class));
    }

    public DataReadQuery(String sqlString) {
        this();
        this.setSQLString(sqlString);
    }

    public DataReadQuery(Call call) {
        this();
        this.setCall(call);
    }

    public Object clone() {
        DataReadQuery cloneQuery = (DataReadQuery)super.clone();
        cloneQuery.setContainerPolicy(this.getContainerPolicy().clone(cloneQuery));
        return cloneQuery;
    }

    public Object executeDatabaseQuery() throws DatabaseException {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        return this.executeNonCursor();
    }

    protected Object executeNonCursor() throws DatabaseException {
        Vector rows = this.getQueryMechanism().executeSelect();
        if (this.useAbstractRecord) {
            Object results = this.getContainerPolicy().buildContainerFromVector(rows, this.getSession());
            return results;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object reportResults = containerPolicy.containerInstance(rows.size());
        Iterator rowsEnum = rows.iterator();
        while (rowsEnum.hasNext()) {
            containerPolicy.addInto((Object)((AbstractRecord)rowsEnum.next()).getValues(), reportResults, this.getSession());
        }
        return reportResults;
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public boolean isDataReadQuery() {
        return true;
    }

    protected void prepare() {
        super.prepare();
        this.getContainerPolicy().prepare(this, this.getSession());
        if (this.getContainerPolicy().overridesRead()) {
            return;
        }
        this.getQueryMechanism().prepareExecuteSelect();
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        this.getContainerPolicy().prepareForExecution();
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        if (containerPolicy == null) {
            return;
        }
        this.containerPolicy = containerPolicy;
    }

    public void useCollectionClass(Class concreteClass) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(concreteClass));
    }

    public void setUseAbstractRecord(boolean useAbstractRecord) {
        this.useAbstractRecord = useAbstractRecord;
    }
}

