/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.schemaframework;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sequencing.TableSequence;
import oracle.toplink.essentials.sessions.DatabaseSession;
import oracle.toplink.essentials.sessions.Session;
import oracle.toplink.essentials.tools.schemaframework.SchemaManager;
import oracle.toplink.essentials.tools.schemaframework.TableDefinition;

public class TableCreator {
    protected Vector tableDefinitions;
    protected String name;
    protected boolean ignoreDatabaseException;

    public TableCreator() {
        this(new Vector());
    }

    public TableCreator(Vector tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
    }

    public void addTableDefinition(TableDefinition tableDefinition) {
        this.tableDefinitions.addElement(tableDefinition);
    }

    public void addTableDefinitions(Collection tableDefs) {
        this.tableDefinitions.addAll(tableDefs);
    }

    public void createConstraints(DatabaseSession session) {
        this.createConstraints(session, new SchemaManager(session));
    }

    public void createConstraints(DatabaseSession session, SchemaManager schemaManager) {
        Enumeration enumtr = this.getTableDefinitions().elements();
        while (enumtr.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumtr.nextElement());
        }
        enumtr = this.getTableDefinitions().elements();
        while (enumtr.hasMoreElements()) {
            try {
                schemaManager.createUniqueConstraints((TableDefinition)enumtr.nextElement());
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        enumtr = this.getTableDefinitions().elements();
        while (enumtr.hasMoreElements()) {
            try {
                schemaManager.createForeignConstraints((TableDefinition)enumtr.nextElement());
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
    }

    public void createTables(DatabaseSession session) {
        this.createTables(session, new SchemaManager(session));
    }

    public void createTables(DatabaseSession session, SchemaManager schemaManager) {
        Enumeration enumtr = this.getTableDefinitions().elements();
        while (enumtr.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumtr.nextElement());
        }
        String sequenceTableName = this.getSequenceTableName(session);
        Enumeration enumtr2 = this.getTableDefinitions().elements();
        while (enumtr2.hasMoreElements()) {
            TableDefinition table = (TableDefinition)enumtr2.nextElement();
            if (table.getName().equals(sequenceTableName)) continue;
            try {
                schemaManager.createObject(table);
                session.getSessionLog().log(1, "default_tables_created", table.getFullName());
            }
            catch (DatabaseException ex) {
                session.getSessionLog().log(1, "default_tables_already_existed", table.getFullName());
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        enumtr2 = this.getTableDefinitions().elements();
        while (enumtr2.hasMoreElements()) {
            try {
                schemaManager.createUniqueConstraints((TableDefinition)enumtr2.nextElement());
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        enumtr2 = this.getTableDefinitions().elements();
        while (enumtr2.hasMoreElements()) {
            try {
                schemaManager.createForeignConstraints((TableDefinition)enumtr2.nextElement());
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        schemaManager.createSequences();
    }

    public void dropConstraints(DatabaseSession session) {
        this.dropConstraints(session, new SchemaManager(session));
    }

    public void dropConstraints(DatabaseSession session, SchemaManager schemaManager) {
        Enumeration enumtr = this.getTableDefinitions().elements();
        while (enumtr.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumtr.nextElement());
        }
        enumtr = this.getTableDefinitions().elements();
        while (enumtr.hasMoreElements()) {
            try {
                schemaManager.dropConstraints((TableDefinition)enumtr.nextElement());
            }
            catch (DatabaseException dbE) {}
        }
    }

    public void dropTables(DatabaseSession session) {
        this.dropTables(session, new SchemaManager(session));
    }

    public void dropTables(DatabaseSession session, SchemaManager schemaManager) {
        Enumeration enumtr = this.getTableDefinitions().elements();
        while (enumtr.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumtr.nextElement());
        }
        enumtr = this.getTableDefinitions().elements();
        while (enumtr.hasMoreElements()) {
            try {
                schemaManager.dropConstraints((TableDefinition)enumtr.nextElement());
            }
            catch (DatabaseException dbE) {}
        }
        String sequenceTableName = this.getSequenceTableName(session);
        Enumeration enumtr2 = this.getTableDefinitions().elements();
        while (enumtr2.hasMoreElements()) {
            TableDefinition table = (TableDefinition)enumtr2.nextElement();
            if (table.getName().equals(sequenceTableName)) continue;
            try {
                schemaManager.dropObject(table);
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Vector getTableDefinitions() {
        return this.tableDefinitions;
    }

    public void replaceTables(DatabaseSession session) {
        this.replaceTables(session, new SchemaManager(session));
    }

    public void replaceTables(DatabaseSession session, SchemaManager schemaManager) {
        this.replaceTablesAndConstraints(schemaManager, session);
        schemaManager.createSequences();
    }

    public void replaceTables(DatabaseSession session, SchemaManager schemaManager, boolean keepSequenceTable) {
        this.replaceTablesAndConstraints(schemaManager, session);
        schemaManager.createOrReplaceSequences(keepSequenceTable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceTablesAndConstraints(SchemaManager schemaManager, DatabaseSession session) {
        Enumeration enumtr = this.getTableDefinitions().elements();
        while (enumtr.hasMoreElements()) {
            schemaManager.buildFieldTypes((TableDefinition)enumtr.nextElement());
        }
        boolean shouldLogExceptionStackTrace = session.getSessionLog().shouldLogExceptionStackTrace();
        if (shouldLogExceptionStackTrace) {
            session.getSessionLog().setShouldLogExceptionStackTrace(false);
        }
        try {
            Enumeration enumtr2 = this.getTableDefinitions().elements();
            while (enumtr2.hasMoreElements()) {
                try {
                    schemaManager.dropConstraints((TableDefinition)enumtr2.nextElement());
                }
                catch (DatabaseException dbE) {}
            }
        }
        finally {
            if (shouldLogExceptionStackTrace) {
                session.getSessionLog().setShouldLogExceptionStackTrace(true);
            }
        }
        String sequenceTableName = this.getSequenceTableName(session);
        Enumeration enumtr3 = this.getTableDefinitions().elements();
        while (enumtr3.hasMoreElements()) {
            TableDefinition table = (TableDefinition)enumtr3.nextElement();
            if (table.getName().equals(sequenceTableName)) continue;
            try {
                schemaManager.replaceObject(table);
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        enumtr3 = this.getTableDefinitions().elements();
        while (enumtr3.hasMoreElements()) {
            try {
                schemaManager.createUniqueConstraints((TableDefinition)enumtr3.nextElement());
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
        enumtr3 = this.getTableDefinitions().elements();
        while (enumtr3.hasMoreElements()) {
            try {
                schemaManager.createForeignConstraints((TableDefinition)enumtr3.nextElement());
            }
            catch (DatabaseException ex) {
                if (this.shouldIgnoreDatabaseException()) continue;
                throw ex;
            }
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTableDefinitions(Vector tableDefinitions) {
        this.tableDefinitions = tableDefinitions;
    }

    boolean shouldIgnoreDatabaseException() {
        return this.ignoreDatabaseException;
    }

    void setIgnoreDatabaseException(boolean ignoreDatabaseException) {
        this.ignoreDatabaseException = ignoreDatabaseException;
    }

    protected String getSequenceTableName(Session session) {
        Sequence sequence;
        String sequenceTableName = null;
        if (session.getProject().usesSequencing() && (sequence = session.getLogin().getDefaultSequence()) instanceof TableSequence) {
            sequenceTableName = ((TableSequence)sequence).getTableName();
        }
        return sequenceTableName;
    }
}

