/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.tools.sessionmanagement;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedGetClassLoaderForClass;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.sessions.DatabaseSession;
import oracle.toplink.essentials.sessions.Session;

public class SessionManager {
    protected static SessionManager manager;
    protected AbstractSession defaultSession;
    protected Hashtable sessions = new Hashtable(5);

    public void addSession(Session session) {
        this.getSessions().put(session.getName(), session);
    }

    public void addSession(String sessionName, Session session) {
        session.setName(sessionName);
        this.getSessions().put(sessionName, session);
    }

    public Session getDefaultSession() {
        if (this.defaultSession == null) {
            this.defaultSession = this.getSession("default");
        }
        return this.defaultSession;
    }

    public void destroySession(String sessionName) {
        DatabaseSession session = (DatabaseSession)this.getSessions().get(sessionName);
        if (session != null) {
            this.destroy(session);
        } else {
            this.logAndThrowException(6, ValidationException.noSessionRegisteredForName(sessionName));
        }
    }

    private void destroy(DatabaseSession session) {
        if (session.isConnected()) {
            session.logout();
        }
        this.sessions.remove(session.getName());
        session = null;
    }

    public void destroyAllSessions() {
        Enumeration toRemoveSessions = this.getSessions().elements();
        while (toRemoveSessions.hasMoreElements()) {
            this.destroy((DatabaseSession)toRemoveSessions.nextElement());
        }
    }

    private ClassLoader getMyClassLoader() {
        Object classLoader = null;
        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
            try {
                return (ClassLoader)AccessController.doPrivileged(new PrivilegedGetClassLoaderForClass(this.getClass()));
            }
            catch (PrivilegedActionException exc) {
                return null;
            }
        }
        return PrivilegedAccessHelper.getClassLoaderForClass(this.getClass());
    }

    public static synchronized SessionManager getManager() {
        if (manager == null) {
            manager = new SessionManager();
        }
        return manager;
    }

    public AbstractSession getSession(String sessionName) {
        return this.getSession(sessionName, this.getMyClassLoader(), true, false, false);
    }

    public AbstractSession getSession(String sessionName, boolean shouldLoginSession) {
        return this.getSession(sessionName, this.getMyClassLoader(), shouldLoginSession, false, false);
    }

    public AbstractSession getSession(String sessionName, boolean shouldLoginSession, boolean shouldRefreshSession) {
        return this.getSession(sessionName, this.getMyClassLoader(), shouldLoginSession, shouldRefreshSession, false);
    }

    public AbstractSession getSession(String sessionName, ClassLoader objectClassLoader) {
        return this.getSession(sessionName, objectClassLoader, true, false, false);
    }

    public synchronized AbstractSession getSession(String sessionName, ClassLoader objectClassLoader, boolean shouldLoginSession, boolean shouldRefreshSession, boolean shouldCheckClassLoader) {
        AbstractSession session = (AbstractSession)this.getSessions().get(sessionName);
        if (shouldCheckClassLoader && session != null && !session.getDatasourcePlatform().getConversionManager().getLoader().equals(objectClassLoader)) {
            shouldRefreshSession = true;
        }
        if ((session == null || shouldRefreshSession) && session != null) {
            if (session.isDatabaseSession() && session.isConnected()) {
                ((DatabaseSession)((Object)session)).logout();
            }
            this.getSessions().remove(sessionName);
        }
        if (session == null) {
            this.logAndThrowException(6, ValidationException.noSessionFound(sessionName, ""));
        } else if (shouldLoginSession && !session.isConnected()) {
            ((DatabaseSession)((Object)session)).login();
        }
        return session;
    }

    private void logAndThrowException(int level, RuntimeException exception) throws RuntimeException {
        AbstractSessionLog.getLog().logThrowable(level, exception);
        throw exception;
    }

    public void setSessions(Hashtable sessions) {
        this.sessions = sessions;
    }

    public Hashtable getSessions() {
        return this.sessions;
    }

    public void setDefaultSession(Session defaultSession) {
        this.defaultSession = (AbstractSession)defaultSession;
        this.addSession("default", defaultSession);
    }

    public static void setManager(SessionManager theManager) {
        manager = theManager;
    }
}

