/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.ahocorasick;

import com.addthis.ahocorasick.MutableInt;
import com.addthis.ahocorasick.OutputResult;
import com.addthis.ahocorasick.OutputSizeCalculator;
import com.addthis.ahocorasick.SearchResult;
import com.addthis.ahocorasick.Searcher;
import com.addthis.ahocorasick.State;
import com.addthis.ahocorasick.StringOutputSizeCalculator;
import com.addthis.ahocorasick.TokensInformation;
import com.google.common.base.Preconditions;
import com.gs.collections.api.list.primitive.MutableIntList;
import com.gs.collections.impl.list.mutable.primitive.IntArrayList;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AhoCorasick {
    private static final Logger log = LoggerFactory.getLogger(AhoCorasick.class);
    private final State root;
    private final OutputSizeCalculator outputSizeCalculator;
    private boolean prepared;
    private static final Comparator<OutputResult> OUTPUT_RESULTS_COMPARATOR = new Comparator<OutputResult>(){

        @Override
        public int compare(OutputResult o1, OutputResult o2) {
            return o1.getStartIndex() - o2.getStartIndex();
        }
    };

    private AhoCorasick(OutputSizeCalculator outputSizeCalculator) {
        Preconditions.checkNotNull((Object)outputSizeCalculator, (Object)"The outputSizeCalculator parameter must be non-null");
        this.root = new State(0);
        this.outputSizeCalculator = outputSizeCalculator;
        this.prepared = false;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void add(String keyword) {
        this.add(keyword, keyword);
    }

    public void add(String keyword, Object output) {
        if (this.prepared) {
            throw new IllegalStateException("can't add keywords after prepare() is called");
        }
        State lastState = this.root.extendAll(keyword);
        lastState.addOutput(output);
    }

    public void prepare() {
        this.prepareFailTransitions();
        this.root.compressPaths();
        this.prepared = true;
    }

    public Iterator<SearchResult> progressiveSearch(String input) {
        return new Searcher(this, this.startSearch(input));
    }

    public List<OutputResult> completeSearch(String input, boolean allowOverlapping, boolean onlyTokens) {
        Searcher searcher = new Searcher(this, this.startSearch(input));
        List<OutputResult> result = this.recollectOutputResults(searcher, input, onlyTokens);
        this.sortOutputResults(result);
        if (!allowOverlapping) {
            this.removeOverlapping(result);
        }
        return result;
    }

    void removeOverlapping(List<OutputResult> outputResults) {
        int currentIndex = 0;
        while (currentIndex < outputResults.size() - 1) {
            OutputResult next;
            OutputResult current = outputResults.get(currentIndex);
            if (!current.isOverlapped(next = outputResults.get(currentIndex + 1))) {
                ++currentIndex;
                continue;
            }
            if (current.dominate(next)) {
                outputResults.remove(currentIndex + 1);
                continue;
            }
            outputResults.remove(currentIndex);
        }
    }

    private void prepareFailTransitions() {
        char[] keys;
        ArrayDeque<State> q = new ArrayDeque<State>();
        for (char key : keys = this.root.keys()) {
            State state = this.root.get(key);
            state.setFail(this.root);
            q.add(state);
        }
        while (!q.isEmpty()) {
            State state = (State)q.remove();
            for (char key : keys = state.keys()) {
                State next = state.get(key);
                q.add(next);
                State fail = state.getFail();
                State failTransition = fail.get(key);
                while (failTransition == null) {
                    fail = fail.getFail();
                    failTransition = fail.get(key);
                }
                next.setFail(failTransition);
                next.addOutputs(failTransition.getOutputs());
            }
        }
    }

    State getRoot() {
        return this.root;
    }

    SearchResult startSearch(String chars) {
        if (!this.prepared) {
            throw new IllegalStateException("can't start search until prepare()");
        }
        return this.continueSearch(new SearchResult(this.root, chars, 0));
    }

    SearchResult continueSearch(SearchResult lastResult) {
        String chars = lastResult.chars;
        State state = lastResult.lastMatchedState;
        MutableInt currentIndex = new MutableInt(lastResult.lastIndex);
        while (currentIndex.getValue() < chars.length()) {
            if ((state = state.next(chars, currentIndex)).getOutputs().size() <= 0) continue;
            return new SearchResult(state, chars, currentIndex.getValue());
        }
        return null;
    }

    private TokensInformation extractTokensInformation(String chars) {
        TokensInformation result = new TokensInformation();
        IntArrayList starts = new IntArrayList();
        IntArrayList ends = new IntArrayList();
        int startIndex = -1;
        for (int index = 0; index < chars.length(); ++index) {
            char current = chars.charAt(index);
            if (!Character.isWhitespace(current)) {
                if (startIndex != -1) continue;
                startIndex = index;
                continue;
            }
            if (startIndex == -1) continue;
            starts.add(startIndex);
            ends.add(index);
            startIndex = -1;
        }
        if (startIndex != -1) {
            starts.add(startIndex);
            ends.add(chars.length());
        }
        result.setEnds((MutableIntList)ends);
        result.setStarts((MutableIntList)starts);
        return result;
    }

    private void sortOutputResults(List<OutputResult> outputResults) {
        Collections.sort(outputResults, OUTPUT_RESULTS_COMPARATOR);
    }

    private List<OutputResult> recollectOutputResults(Searcher searcher, String chars, boolean onlyTokens) {
        TokensInformation tokensInformation = null;
        ArrayList<OutputResult> result = new ArrayList<OutputResult>();
        if (searcher.hasNext() && onlyTokens) {
            tokensInformation = this.extractTokensInformation(chars);
        }
        while (searcher.hasNext()) {
            SearchResult searchResult = searcher.next();
            for (Object output : searchResult.getOutputs()) {
                int startIndex = searchResult.lastIndex - this.outputSizeCalculator.calculateSize(output);
                if (onlyTokens && !tokensInformation.areValidOffsets(startIndex, searchResult.lastIndex)) continue;
                result.add(new OutputResult(output, startIndex, searchResult.lastIndex));
            }
        }
        return result;
    }

    public static class Builder {
        private OutputSizeCalculator outputSizeCalculator = new StringOutputSizeCalculator();

        public Builder setOutputSizeCalculator(OutputSizeCalculator calculator) {
            this.outputSizeCalculator = calculator;
            return this;
        }

        public AhoCorasick build() {
            return new AhoCorasick(this.outputSizeCalculator);
        }
    }
}

