/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.ahocorasick;

import com.addthis.ahocorasick.EdgeList;
import com.addthis.ahocorasick.MutableInt;
import com.addthis.ahocorasick.SparseEdgeList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

class State {
    private static final State EMPTY_STATE = new State(-1);
    private static final char[] EMPTY_KEYS = new char[0];
    private final int depth;
    private EdgeList edgeList;
    private State fail;
    private Set<Object> outputs;
    private char[] fastPath;
    private State[] fastTransitions;
    private boolean incomingFail;

    State(int depth) {
        this.depth = depth;
        this.edgeList = null;
        this.fail = null;
        this.outputs = ImmutableSet.of();
    }

    State extend(char c) {
        State nextState;
        if (this.edgeList == null) {
            this.edgeList = new SparseEdgeList();
        }
        if ((nextState = this.edgeList.get(c)) == null) {
            nextState = new State(this.depth + 1);
            this.edgeList.put(c, nextState);
        }
        return nextState;
    }

    State extendAll(String chars) {
        State state = this;
        for (int i = 0; i < chars.length(); ++i) {
            State nextState;
            if (state.edgeList == null) {
                state.edgeList = new SparseEdgeList();
            }
            if ((nextState = state.edgeList.get(chars.charAt(i))) == null) {
                nextState = state.extend(chars.charAt(i));
            }
            state = nextState;
        }
        return state;
    }

    private boolean isCompressible() {
        return this.edgeList != null && this.edgeList.size() == 1 && this.outputs.size() == 0 && !this.incomingFail && !this.isRoot();
    }

    void compressPaths() {
        if (this.isCompressible()) {
            StringBuilder builder = new StringBuilder();
            ArrayList<State> transitions = new ArrayList<State>();
            State next = this;
            do {
                transitions.add(next.getFail());
                char nextChar = next.edgeList.keys()[0];
                next = next.edgeList.get(nextChar);
                builder.append(nextChar);
            } while (next.isCompressible());
            if (builder.length() > 1) {
                transitions.add(next);
                this.fastPath = builder.toString().toCharArray();
                this.fastTransitions = transitions.toArray(new State[transitions.size()]);
                this.edgeList = null;
                this.fail = null;
            }
            next.compressPaths();
        } else if (this.edgeList != null) {
            for (State next : this.edgeList.values()) {
                next.compressPaths();
            }
        }
    }

    int size() {
        char[] keys;
        int result = 1;
        if (this.edgeList == null) {
            return result;
        }
        for (char key : keys = this.edgeList.keys()) {
            result += this.edgeList.get(key).size();
        }
        return result;
    }

    State get(char c) {
        State s;
        assert (this.fastPath == null);
        State state = s = this.edgeList != null ? this.edgeList.get(c) : null;
        if (s == null && this.isRoot()) {
            return this;
        }
        return s;
    }

    State next(String input, MutableInt currentIndex) {
        int index;
        if (this.fastPath == null) {
            char nextChar = input.charAt(currentIndex.getAndIncrement());
            return this.followFailureTransitions(nextChar, this);
        }
        char nextChar = '\u0000';
        for (index = 0; index < this.fastPath.length; ++index) {
            if (currentIndex.getValue() == input.length()) {
                return EMPTY_STATE;
            }
            nextChar = input.charAt(currentIndex.getAndIncrement());
            if (nextChar != this.fastPath[index]) break;
        }
        if (index == this.fastPath.length) {
            return this.fastTransitions[index];
        }
        return this.followFailureTransitions(nextChar, this.fastTransitions[index]);
    }

    private State followFailureTransitions(char nextChar, State current) {
        State next = current.get(nextChar);
        while (next == null) {
            current = current.getFail();
            next = current.get(nextChar);
        }
        return next;
    }

    char[] keys() {
        return this.edgeList != null ? this.edgeList.keys() : EMPTY_KEYS;
    }

    State getFail() {
        return this.fail;
    }

    void setFail(State f) {
        f.incomingFail = true;
        this.fail = f;
    }

    void addOutput(Object output) {
        if (!this.outputs.contains(output)) {
            if (this.outputs.size() == 0) {
                this.outputs = ImmutableSet.of((Object)output);
            } else {
                if (this.outputs.size() == 1) {
                    this.outputs = new HashSet<Object>(this.outputs);
                }
                this.outputs.add(output);
            }
        }
    }

    void addOutputs(Collection<Object> newOutputs) {
        if (this.outputs.size() < 2) {
            this.outputs = new HashSet<Object>(this.outputs);
        }
        this.outputs.addAll(newOutputs);
    }

    Set<Object> getOutputs() {
        return this.outputs;
    }

    boolean isRoot() {
        return this.depth == 0;
    }

    int getDepth() {
        return this.depth;
    }

    String getFastPath() {
        return new String(this.fastPath);
    }

    State[] getFastTransitions() {
        return this.fastTransitions;
    }
}

