/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.chars;

import com.addthis.basis.chars.CharBuf;
import com.addthis.basis.chars.ReadOnlyAsciiBuf;
import com.google.common.annotations.Beta;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.charset.UnmappableCharacterException;

@Beta
public class AsciiBuf
extends ReadOnlyAsciiBuf
implements CharBuf {
    public AsciiBuf(ByteBuf data) {
        super(data);
    }

    public AsciiBuf(CharBuf charBuf) {
        this(charBuf.toByteBuf());
    }

    @Override
    public Appendable append(CharSequence csq) throws IOException {
        return this.append(csq, 0, csq.length());
    }

    @Override
    public Appendable append(CharSequence csq, int start, int end) throws IOException {
        if (csq.length() < end) {
            throw new IndexOutOfBoundsException();
        }
        if (csq instanceof ReadOnlyAsciiBuf) {
            this.content().writeBytes(((ReadOnlyAsciiBuf)csq).content());
        } else {
            for (int i = start; i < end; ++i) {
                char c = csq.charAt(i);
                if (c >= '\u0080') {
                    throw new UnmappableCharacterException(2);
                }
                this.content().writeByte((int)((byte)c));
            }
        }
        return this;
    }

    @Override
    public Appendable append(char c) throws IOException {
        if (c >= '\u0080') {
            throw new UnmappableCharacterException(2);
        }
        this.content().writeByte((int)((byte)c));
        return this;
    }
}

