/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.chars;

import com.addthis.basis.chars.ByteArrayReadOnlyAsciiBuf;
import com.addthis.basis.chars.ByteArrayReadOnlyUtfBuf;
import com.addthis.basis.chars.ReadOnlyUtfBuf;
import com.addthis.basis.chars.ReadableCharBuf;
import com.google.common.annotations.Beta;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufProcessor;
import java.nio.charset.UnmappableCharacterException;

@Beta
public final class CharBufs {
    public static final ByteBufProcessor FIND_NEGATIVE = new ByteBufProcessor(){

        public boolean process(byte value) throws Exception {
            return value < 0;
        }
    };

    private CharBufs() {
    }

    public static ReadableCharBuf utf(byte[] bytes) {
        return new ByteArrayReadOnlyUtfBuf(bytes);
    }

    public static ReadableCharBuf utf(ByteBuf bytes) {
        return new ReadOnlyUtfBuf(bytes);
    }

    public static ReadableCharBuf utf(ByteBufHolder byteHolder) {
        return new ReadOnlyUtfBuf(byteHolder.content());
    }

    public static ReadableCharBuf ascii(char[] values, int start, int length) {
        byte[] data = new byte[length];
        for (int i = start; i < start + length; ++i) {
            char c = values[i];
            if (c >= '\u0080') {
                throw new RuntimeException(new UnmappableCharacterException(2));
            }
            data[i] = (byte)c;
        }
        return new ByteArrayReadOnlyAsciiBuf(data);
    }

    public static ReadableCharBuf ascii(char[] values) {
        return CharBufs.ascii(values, 0, values.length);
    }
}

