/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.chars;

import com.addthis.basis.chars.AbstractReadOnlyUtfBuf;
import com.addthis.basis.chars.ReadableCharBuf;
import com.google.common.annotations.Beta;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.util.IllegalReferenceCountException;
import java.nio.charset.StandardCharsets;

@Beta
public class ReadOnlyUtfBuf
extends AbstractReadOnlyUtfBuf
implements ReadableCharBuf,
ByteBufHolder {
    private final ByteBuf data;

    public ReadOnlyUtfBuf(ByteBuf data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = data;
    }

    ReadOnlyUtfBuf(ByteBuf data, int cacheInstance) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        this.data = data;
        this.packedIndexCache = cacheInstance;
    }

    ReadOnlyUtfBuf(ByteBuf data, int charDelta, int byteIndex) {
        this(data, ReadOnlyUtfBuf.packIndexCache(charDelta, byteIndex));
    }

    public ReadOnlyUtfBuf(ByteBufHolder charBuf) {
        this(charBuf.content());
    }

    @Override
    public byte getByte(int index) {
        return this.content().getByte(index);
    }

    @Override
    public int getByteLength() {
        return this.content().readableBytes();
    }

    @Override
    public ReadableCharBuf getSubSequenceForByteBounds(int start, int end) {
        return new ReadOnlyUtfBuf(this.data.slice(start, end - start));
    }

    @Override
    public String toString() {
        return this.content().toString(StandardCharsets.UTF_8);
    }

    @Override
    public int compareTo(ReadableCharBuf o) {
        if (o instanceof ReadOnlyUtfBuf) {
            return ByteBufUtil.compare((ByteBuf)((ReadOnlyUtfBuf)o).content(), (ByteBuf)this.content());
        }
        return super.compareTo(o);
    }

    @Override
    public ByteBuf toByteBuf() {
        return this.content();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ReadableCharBuf) {
            return ByteBufUtil.equals((ByteBuf)((ReadableCharBuf)obj).toByteBuf(), (ByteBuf)this.content());
        }
        return false;
    }

    public ByteBuf content() {
        if (this.data.refCnt() <= 0) {
            throw new IllegalReferenceCountException(this.data.refCnt());
        }
        return this.data;
    }

    public ByteBufHolder copy() {
        return new DefaultByteBufHolder(this.data.copy());
    }

    public ByteBufHolder duplicate() {
        return new DefaultByteBufHolder(this.data.duplicate());
    }

    public int refCnt() {
        return this.data.refCnt();
    }

    public ByteBufHolder retain() {
        this.data.retain();
        return this;
    }

    public ByteBufHolder retain(int increment) {
        this.data.retain(increment);
        return this;
    }

    public boolean release() {
        return this.data.release();
    }

    public boolean release(int decrement) {
        return this.data.release(decrement);
    }
}

