/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.collect;

import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;

public class CountMap
extends LinkedHashMap<String, Long>
implements Comparator<String> {
    private long sum;
    private long max;
    private long min;

    public CountMap add(String str, long value) {
        Long val = (Long)this.get(str);
        Long nval = val != null ? val + value : value;
        this.max = Math.max(nval, this.max);
        this.min = this.min == 0L ? value : Math.min(this.min, value);
        this.put(str, nval);
        this.sum += value;
        return this;
    }

    public void add(CountMap map) {
        for (String key : map.keySet()) {
            this.add(key, (Long)map.get(key));
        }
    }

    @Override
    public void clear() {
        this.sum = 0L;
        this.max = 0L;
        this.min = 0L;
        super.clear();
    }

    public long getSum() {
        return this.sum;
    }

    public long getMax() {
        return this.max;
    }

    public long getMin() {
        return this.min;
    }

    public long getAverage() {
        return this.size() > 0 ? this.sum / (long)this.size() : 0L;
    }

    public String[] getSortedKeys() {
        String[] keys = this.keySet().toArray(new String[this.size()]);
        Arrays.sort(keys, this);
        return keys;
    }

    @Override
    public int compare(String s1, String s2) {
        return (int)((Long)this.get(s2) - (Long)this.get(s1));
    }

    public boolean equals(Object s1, Object s2) {
        return s1.equals(s2);
    }
}

