/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.collect;

import java.util.Iterator;
import java.util.Map;

public final class HotMap<K, V>
implements Iterable<Map.Entry<K, V>> {
    private Map<K, MapEntry> map;
    private MapEntry firstEntry;
    private MapEntry lastEntry;

    public HotMap(Map map) {
        this.map = map;
    }

    public String toString() {
        return this.map.toString();
    }

    protected MapEntry createMapEntry(K key, V val) {
        return new MapEntry(key, val);
    }

    private String iteratorToString(Iterator<?> i) {
        StringBuilder sb = new StringBuilder("<");
        while (i.hasNext()) {
            sb.append(i.next().toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(">");
        return sb.toString();
    }

    public int size() {
        return this.map.size();
    }

    public void clear() {
        this.map.clear();
        this.firstEntry = null;
        this.lastEntry = null;
    }

    public Iterator<Map.Entry<K, V>> entriesFromMap() {
        return new MapIterator(this.map.entrySet().iterator());
    }

    public Iterator<Map.Entry<K, V>> entriesByUse() {
        return new UseMapIterator();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new UseMapIterator();
    }

    public V get(K key) {
        MapEntry e = this.map.get(key);
        if (e != null) {
            this.updateLinks(e);
            return e.value;
        }
        return null;
    }

    public V peek(K key) {
        return this.map.get(key).value;
    }

    public Map.Entry<K, V> getEntry(K key) {
        MapEntry e = this.map.get(key);
        if (e != null) {
            this.updateLinks(e);
            return e;
        }
        return null;
    }

    public V put(K key, V value) {
        MapEntry e = this.map.get(key);
        if (e != null) {
            this.updateLinks(e);
            return e.setValue(value);
        }
        e = this.createMapEntry(key, value);
        this.map.put(key, e);
        this.updateLinks(e);
        return null;
    }

    public V remove(K key) {
        MapEntry e = this.map.remove(key);
        if (e != null) {
            this.delink(e);
            return e.value;
        }
        return null;
    }

    public V peekEldest() {
        return this.firstEntry != null ? (V)this.firstEntry.value : null;
    }

    public Map.Entry<K, V> peekEldestEntry() {
        return this.firstEntry != null ? this.firstEntry : null;
    }

    public V removeEldest() {
        Map.Entry<K, V> e = this.removeEldestEntry();
        return e != null ? (V)e.getValue() : null;
    }

    public Map.Entry<K, V> removeEldestEntry() {
        if (this.firstEntry != null) {
            MapEntry e = this.map.remove(this.firstEntry.key);
            this.delink(this.firstEntry);
            return e;
        }
        return null;
    }

    private void delink(MapEntry e) {
        if (e == this.firstEntry) {
            this.firstEntry = e.next;
        }
        if (e == this.lastEntry) {
            this.lastEntry = e.prev;
        }
        if (e.prev != null) {
            e.prev.next = e.next;
        }
        if (e.next != null) {
            e.next.prev = e.prev;
        }
        e.next = null;
        e.prev = null;
    }

    private void updateLinks(MapEntry e) {
        this.delink(e);
        if (this.firstEntry == null) {
            this.firstEntry = e;
        }
        if (this.lastEntry != null) {
            e.prev = this.lastEntry;
            this.lastEntry.next = e;
        }
        this.lastEntry = e;
    }

    public Map<K, MapEntry> getMap() {
        return this.map;
    }

    private final class UseMapIterator
    implements Iterator<Map.Entry<K, V>> {
        MapEntry current;
        MapEntry last;

        private UseMapIterator() {
            this.current = HotMap.this.firstEntry;
            this.last = null;
        }

        public String toString() {
            return HotMap.this.iteratorToString(this);
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public Map.Entry<K, V> next() {
            MapEntry ret = HotMap.this.createMapEntry(this.current.key, this.current.value);
            this.last = this.current;
            this.current = this.current.next;
            if (this.current == this.last) {
                throw new RuntimeException("error. circular link in hot map use list");
            }
            return ret;
        }

        @Override
        public void remove() {
            if (this.last != null) {
                HotMap.this.delink(this.last);
            }
        }
    }

    private final class MapIterator
    implements Iterator<Map.Entry<K, V>> {
        Iterator<Map.Entry<K, MapEntry>> iter;
        MapEntry last;

        private MapIterator(Iterator<Map.Entry<K, MapEntry>> iterator) {
            this.iter = iterator;
        }

        public String toString() {
            return HotMap.this.iteratorToString(this);
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            this.last = this.iter.next().getValue();
            return HotMap.this.createMapEntry(this.last.key, this.last.value);
        }

        @Override
        public void remove() {
            HotMap.this.delink(this.last);
            this.iter.remove();
        }
    }

    protected final class MapEntry
    implements Map.Entry<K, V> {
        K key;
        V value;
        MapEntry prev;
        MapEntry next;

        MapEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            Object oldval = this.value;
            this.value = value;
            return oldval;
        }

        public String toString() {
            return "[" + this.key + "," + this.value + "]";
        }
    }
}

