/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.zip.GZIPInputStream;

public class GZIPInputStreamX
extends GZIPInputStream {
    private GZIPInputStreamX parent;
    private GZIPInputStreamX child;
    private int size;
    private boolean eos;

    public GZIPInputStreamX(InputStream in, int size) throws IOException {
        super((InputStream)new PushbackInputStream(in, size), size);
        this.size = size;
    }

    public GZIPInputStreamX(InputStream in) throws IOException {
        super(new PushbackInputStream(in, 2048));
        this.size = -1;
    }

    private GZIPInputStreamX(GZIPInputStreamX newparent) throws IOException {
        super(newparent.in);
        this.setParent(newparent);
        this.size = -1;
    }

    private GZIPInputStreamX(GZIPInputStreamX newparent, int size) throws IOException {
        super(newparent.in, size);
        this.setParent(newparent);
        this.size = size;
    }

    private void setParent(GZIPInputStreamX newparent) {
        while (newparent.parent != null) {
            newparent = newparent.parent;
        }
        this.parent = newparent;
        this.parent.child = this;
    }

    @Override
    public int read(byte[] inbuf, int inoff, int inlen) throws IOException {
        if (this.eos) {
            return -1;
        }
        if (this.child != null) {
            return this.child.read(inbuf, inoff, inlen);
        }
        int read = 0;
        try {
            read = super.read(inbuf, inoff, inlen);
        }
        catch (IOException e) {
            if (e.getMessage().contains("Corrupt GZIP trailer")) {
                read = -1;
            }
            throw e;
        }
        if (read == -1) {
            int n = this.inf.getRemaining() - 8;
            if (n > 0) {
                ((PushbackInputStream)this.in).unread(this.buf, this.len - n, n);
            } else {
                byte[] b = new byte[1];
                int ret = this.in.read(b, 0, 1);
                if (ret == -1) {
                    this.eos = true;
                    return -1;
                }
                ((PushbackInputStream)this.in).unread(b, 0, 1);
            }
            GZIPInputStreamX child = this.size == -1 ? new GZIPInputStreamX(this) : new GZIPInputStreamX(this, this.size);
            return child.read(inbuf, inoff, inlen);
        }
        return read;
    }
}

