/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.io;

import com.addthis.basis.io.GZIPInputStreamX;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPOutputStream;

public final class IOWrap {
    private IOWrap() {
    }

    public static InputStream buffer(InputStream in, int buffer) {
        return buffer > 0 ? new BufferedInputStream(in, buffer) : in;
    }

    public static InputStream gz(InputStream in, int buffer) {
        try {
            return buffer > 0 ? new GZIPInputStreamX(in, buffer) : new GZIPInputStreamX(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static OutputStream buffer(OutputStream out, int buffer) {
        return buffer > 0 ? new BufferedOutputStream(out) : out;
    }

    public static OutputStream gz(OutputStream in, int buffer) {
        try {
            return buffer > 0 ? new GZIPOutputStream(in, buffer) : new GZIPOutputStream(in);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InputStream fileIn(File file, int buffer, boolean gz) throws FileNotFoundException {
        return gz ? IOWrap.gz(new FileInputStream(file), buffer) : IOWrap.buffer(new FileInputStream(file), buffer);
    }

    public static OutputStream fileOut(File file, int buffer, boolean gz, boolean append) throws FileNotFoundException {
        return gz ? IOWrap.gz(new FileOutputStream(file, append), buffer) : IOWrap.buffer(new FileOutputStream(file, append), buffer);
    }
}

