/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.jmx;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;

public class DynamicMBeanImpl
implements DynamicMBean {
    Object target;
    Map<String, Method> methods;
    MBeanInfo info;

    public DynamicMBeanImpl(Object obj, Collection<Class<?>> ifcs, Collection<String> names) throws IntrospectionException {
        this.target = obj;
        this.methods = new HashMap<String, Method>();
        if (ifcs != null) {
            for (Class<?> ifc : ifcs) {
                for (Method method : ifc.getMethods()) {
                    String key;
                    if (method.getDeclaringClass() == Object.class || this.methods.containsKey(key = method.getName() + "/" + method.getParameterTypes().length)) continue;
                    this.methods.put(key, method);
                }
            }
        }
        if (names != null && names.size() > 0) {
            for (Method method : this.target.getClass().getMethods()) {
                String key;
                if (!names.contains(method.getName()) || method.getDeclaringClass() == Object.class || this.methods.containsKey(key = method.getName() + "/" + method.getParameterTypes().length)) continue;
                this.methods.put(key, method);
            }
        }
        LinkedList<MBeanOperationInfo> ops = new LinkedList<MBeanOperationInfo>();
        for (Method method : this.methods.values()) {
            ops.add(new MBeanOperationInfo(null, method));
        }
        LinkedList<MBeanAttributeInfo> atts = new LinkedList<MBeanAttributeInfo>();
        for (String key : this.methods.keySet()) {
            if (!key.startsWith("get") || !key.endsWith("/0")) continue;
            String name = key.substring(3, key.indexOf("/"));
            Method getter = this.methods.get(key);
            Method setter = this.methods.get("set" + name + "/1");
            atts.add(new MBeanAttributeInfo(name, null, getter, setter));
        }
        MBeanOperationInfo[] o = ops.toArray(new MBeanOperationInfo[ops.size()]);
        MBeanAttributeInfo[] a = atts.toArray(new MBeanAttributeInfo[atts.size()]);
        this.info = new MBeanInfo(this.target.getClass().getName(), null, a, null, o, null);
    }

    @Override
    public Object getAttribute(String att) throws AttributeNotFoundException, MBeanException, ReflectionException {
        Method getter = this.methods.get("get" + att + "/0");
        if (getter == null) {
            throw new ReflectionException(null, "no getter for " + att);
        }
        try {
            return getter.invoke(this.target, new Object[0]);
        }
        catch (Exception e) {
            throw new MBeanException(e, "error getting att " + att);
        }
    }

    @Override
    public AttributeList getAttributes(String[] atts) {
        AttributeList list = new AttributeList();
        for (String att : atts) {
            try {
                list.add(new Attribute(att, this.getAttribute(att)));
            }
            catch (JMException e) {
                // empty catch block
            }
        }
        return list;
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        return this.info;
    }

    @Override
    public Object invoke(String name, Object[] params, String[] signature) throws MBeanException, ReflectionException {
        String text = name + "(" + Arrays.toString(signature) + ")";
        Method method = this.methods.get(name + "/" + signature.length);
        if (method == null) {
            throw new ReflectionException(null, "no such method: " + text);
        }
        try {
            return method.invoke(this.target, params);
        }
        catch (Exception e) {
            throw new MBeanException(e, "error invoking method " + text);
        }
    }

    @Override
    public void setAttribute(Attribute att) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        Method setter = this.methods.get("set" + att.getName() + "/1");
        if (setter == null) {
            throw new ReflectionException(null, "no setter for " + att);
        }
        try {
            setter.invoke(this.target, att.getValue());
        }
        catch (Exception e) {
            throw new MBeanException(e, "error setting att " + att);
        }
    }

    @Override
    public AttributeList setAttributes(AttributeList atts) {
        AttributeList list = new AttributeList();
        for (Attribute att : atts.asList()) {
            try {
                this.setAttribute(att);
                list.add(att);
            }
            catch (JMException e) {}
        }
        return list;
    }
}

