/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.jmx;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Collections;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;

public class MBeanRemotingSupport
implements RMIServerSocketFactory {
    static final String URL_PATTERN = "service:jmx:rmi:///jndi/rmi://:{PORT}/jmxrmi";
    static final String PROP_RIDS = "java.rmi.server.randomIDs";
    static final String PROP_SOCK = "jmx.remote.rmi.server.socket.factory";
    int port;
    Acceptor acceptor;
    JMXServiceURL url;
    JMXConnectorServer connector;

    public MBeanRemotingSupport(int port) {
        this(port, null);
    }

    public MBeanRemotingSupport(int port, Acceptor acceptor) {
        this.port = port;
        this.acceptor = acceptor;
        this.connector = null;
        try {
            this.url = new JMXServiceURL(URL_PATTERN.replace("{PORT}", Integer.toString(port)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("WTF?", e);
        }
        System.setProperty(PROP_RIDS, "true");
    }

    public int getPort() {
        return this.port;
    }

    public JMXServiceURL getUrl() {
        return this.url;
    }

    public JMXConnectorServer getConnectorServer() {
        return this.connector;
    }

    public void start() throws IOException {
        if (this.connector != null) {
            throw new IllegalArgumentException("already started");
        }
        LocateRegistry.createRegistry(this.port);
        this.connector = JMXConnectorServerFactory.newJMXConnectorServer(this.url, Collections.singletonMap(PROP_SOCK, this), ManagementFactory.getPlatformMBeanServer());
        this.connector.start();
    }

    public void stop() throws IOException {
        try {
            if (this.connector != null) {
                this.connector.stop();
            }
        }
        finally {
            this.connector = null;
        }
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        return new ServerSocket(port){

            @Override
            public Socket accept() throws IOException {
                Socket client = null;
                while (client == null) {
                    client = super.accept();
                    if (MBeanRemotingSupport.this.acceptor == null || MBeanRemotingSupport.this.acceptor.accept(client)) continue;
                    client.close();
                    client = null;
                }
                return client;
            }
        };
    }

    public static interface Acceptor {
        public boolean accept(Socket var1);
    }
}

