/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.jmx;

import com.addthis.basis.jmx.DynamicMBeanImpl;
import com.addthis.basis.jmx.MBeanListener;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.Attribute;
import javax.management.DynamicMBean;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanFeatureInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;

public class MBeanUtils {
    public static final ObjectName DELEGATE = MBeanUtils.parseName("JMImplementation:type=MBeanServerDelegate");
    public static final String MBEAN_ADD = "JMX.mbean.registered";
    public static final String MBEAN_DEL = "JMX.mbean.unregistered";
    public static final String URL_PATTERN = "service:jmx:rmi:///jndi/rmi://{{host}}:{{port}}/jmxrmi";
    static final Map<Integer, Set<ObjectName>> registered = new HashMap<Integer, Set<ObjectName>>();
    static final Map<Integer, NotificationListener> listeners = new HashMap<Integer, NotificationListener>();

    public static ObjectName parseName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("bad name " + name, e);
        }
    }

    public static ObjectName buildName(String domain, Object ... props) {
        StringBuilder str = new StringBuilder();
        str.append(domain).append(":");
        for (int i = 0; i < props.length; i += 2) {
            if (i > 0) {
                str.append(",");
            }
            str.append(props[i]).append("=").append(String.valueOf(props[i + 1]));
        }
        return MBeanUtils.parseName(str.toString());
    }

    public static boolean match(ObjectName pattern, ObjectName target) {
        return pattern == null || pattern.apply(target);
    }

    private static void putName(int code, ObjectName name) {
        Set<ObjectName> set = registered.get(code);
        if (set == null) {
            set = new HashSet<ObjectName>();
            registered.put(code, set);
        }
        set.add(name);
    }

    public static void register(ObjectName name, Object target) {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(target, name);
            MBeanUtils.putName(System.identityHashCode(target), name);
        }
        catch (JMException e) {
            throw new RuntimeException("oops! couldn't register " + name, e);
        }
    }

    public static void register(ObjectName name, Object target, Object ... metadata) {
        LinkedList ifcs = new LinkedList();
        LinkedList<String> methods = new LinkedList<String>();
        for (Object o : metadata) {
            if (o instanceof Class) {
                ifcs.add((Class)o);
                continue;
            }
            methods.add(o.toString());
        }
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(MBeanUtils.createDynamicMBean(target, ifcs, methods), name);
            MBeanUtils.putName(System.identityHashCode(target), name);
        }
        catch (JMException e) {
            throw new RuntimeException("oops! couldn't register " + name, e);
        }
    }

    public static void register(ObjectName name, Object obj, String ... methods) {
        try {
            ManagementFactory.getPlatformMBeanServer().registerMBean(MBeanUtils.createDynamicMBean(obj, null, Arrays.asList(methods)), name);
            MBeanUtils.putName(System.identityHashCode(obj), name);
        }
        catch (JMException e) {
            throw new RuntimeException("oops! couldn't register " + name, e);
        }
    }

    public static void unregister(ObjectName name) {
        try {
            ManagementFactory.getPlatformMBeanServer().unregisterMBean(name);
        }
        catch (JMException e) {
            throw new RuntimeException("oops! couldn't register " + name, e);
        }
    }

    public static void unregister(Object obj) {
        for (ObjectName name : registered.remove(System.identityHashCode(obj))) {
            MBeanUtils.unregister(name);
        }
    }

    public static void listen(MBeanListener listener, ObjectName pattern) {
        MBeanUtils.listen(listener, pattern, System.identityHashCode(listener));
    }

    public static <T> Map<ObjectName, T> listen(ObjectName pattern, final Class<T> type) {
        final ConcurrentHashMap map = new ConcurrentHashMap();
        MBeanListener listener = new MBeanListener(){

            @Override
            public void mbeanAdded(ObjectName name) {
                map.put(name, MBeanUtils.createProxy(name, type));
            }

            @Override
            public void mbeanRemoved(ObjectName name) {
                map.remove(name);
            }
        };
        MBeanUtils.listen(listener, pattern, System.identityHashCode(map));
        return map;
    }

    protected static void listen(final MBeanListener listener, final ObjectName pattern, int key) {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            NotificationListener jmxlisten = new NotificationListener(){

                @Override
                public void handleNotification(Notification notification, Object handback) {
                    MBeanServerNotification n = (MBeanServerNotification)notification;
                    if (MBeanUtils.match(pattern, n.getMBeanName())) {
                        if (MBeanUtils.MBEAN_ADD.equals(n.getType())) {
                            listener.mbeanAdded(n.getMBeanName());
                        }
                        if (MBeanUtils.MBEAN_DEL.equals(n.getType())) {
                            listener.mbeanRemoved(n.getMBeanName());
                        }
                    }
                }
            };
            server.addNotificationListener(DELEGATE, jmxlisten, null, null);
            listeners.put(key, jmxlisten);
            for (ObjectName name : server.queryNames(pattern, null)) {
                listener.mbeanAdded(name);
            }
        }
        catch (JMException e) {
            throw new RuntimeException("error adding listener to " + pattern, e);
        }
    }

    public static void unlisten(Object listener) {
        NotificationListener jmxlisten = listeners.remove(System.identityHashCode(listener));
        try {
            ManagementFactory.getPlatformMBeanServer().removeNotificationListener(DELEGATE, jmxlisten);
        }
        catch (JMException e) {
            throw new RuntimeException("couldn't unlisten", e);
        }
    }

    public static DynamicMBean createDynamicMBean(Object target, Collection<Class<?>> ifcs, Collection<String> methods) throws JMException {
        return new DynamicMBeanImpl(target, ifcs, methods);
    }

    public static <T> T createProxy(ObjectName name, Class<T> ifc) {
        return MBeanUtils.createProxy(ifc.getClassLoader(), name, ifc);
    }

    public static <T> T createProxy(ClassLoader loader, ObjectName name, Class<T> ifc) {
        return MBeanUtils.createProxy(ManagementFactory.getPlatformMBeanServer(), loader, name, ifc);
    }

    public static <T> T createProxy(final MBeanServerConnection conn, ClassLoader loader, ObjectName name, Class<T> ifc) {
        final ObjectName target = name;
        if (!MBeanUtils.supports(target, ifc)) {
            throw new IllegalArgumentException(name + " doesn't support " + ifc.getName());
        }
        InvocationHandler handler = new InvocationHandler(){
            MBeanInfo info = null;

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (this.info == null) {
                    this.info = conn.getMBeanInfo(target);
                }
                if (args == null) {
                    args = new Object[]{};
                }
                String mname = method.getName();
                String aname = MBeanUtils.getAttributeName(method);
                if (aname != null) {
                    aname = aname.toLowerCase();
                    for (MBeanAttributeInfo att : this.info.getAttributes()) {
                        if (!att.getName().equalsIgnoreCase(aname)) continue;
                        aname = att.getName();
                        break;
                    }
                    if (mname.startsWith("get")) {
                        return conn.getAttribute(target, aname);
                    }
                    conn.setAttribute(target, new Attribute(aname, args[0]));
                    return null;
                }
                String[] sig = new String[args.length];
                for (int i = 0; i < sig.length; ++i) {
                    sig[i] = method.getParameterTypes()[i].getName();
                }
                return conn.invoke(target, method.getName(), args, sig);
            }
        };
        return ifc.cast(Proxy.newProxyInstance(loader, new Class[]{ifc}, handler));
    }

    public static boolean supports(ObjectName name, Class<?> ifc) {
        MBeanInfo info = null;
        try {
            info = ManagementFactory.getPlatformMBeanServer().getMBeanInfo(name);
        }
        catch (JMException e) {
            return false;
        }
        return MBeanUtils.supports(info, ifc);
    }

    public static boolean supports(MBeanInfo info, Class<?> ifc) {
        for (Method method : ifc.getMethods()) {
            if (MBeanUtils.supports(info, method)) continue;
            return false;
        }
        return true;
    }

    public static boolean supports(MBeanInfo info, Method method) {
        String mname = method.getName();
        String aname = MBeanUtils.getAttributeName(method);
        if (aname != null) {
            for (MBeanAttributeInfo att : info.getAttributes()) {
                if (!att.getName().equalsIgnoreCase(aname)) continue;
                if (mname.startsWith("get") && att.isReadable()) {
                    return true;
                }
                return mname.startsWith("set") && att.isWritable();
            }
            return false;
        }
        LinkedList<String> osig = new LinkedList<String>();
        LinkedList<String> msig = new LinkedList<String>();
        for (Class<?> clazz : method.getParameterTypes()) {
            msig.add(clazz.getName());
        }
        for (Serializable serializable : info.getOperations()) {
            osig.clear();
            for (MBeanParameterInfo param : ((MBeanOperationInfo)serializable).getSignature()) {
                osig.add(param.getType());
            }
            if (!((MBeanFeatureInfo)serializable).getName().equals(method.getName()) || !osig.equals(msig)) continue;
            return true;
        }
        return false;
    }

    public static String getAttributeName(Method method) {
        String name = method.getName();
        if (name.startsWith("set") && method.getReturnType() == Void.TYPE && method.getParameterTypes().length == 1) {
            return name.substring(3);
        }
        if (name.startsWith("get") && method.getReturnType() != Void.TYPE && method.getParameterTypes().length == 0) {
            return name.substring(3);
        }
        return null;
    }

    public static MBeanServerConnection connect(String host, int port) throws IOException {
        String u = URL_PATTERN;
        u = u.replace("{{host}}", host);
        u = u.replace("{{port}}", Integer.toString(port));
        return JMXConnectorFactory.connect(new JMXServiceURL(u)).getMBeanServerConnection();
    }
}

