/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.kv;

import com.addthis.basis.kv.KVPair;
import com.addthis.basis.util.LessBytes;
import com.addthis.basis.util.LessStrings;

public class KAPair
extends KVPair {
    private String key;
    private String[] vals;

    public KAPair(String key, String val) {
        super(key, val);
    }

    public KAPair(String key, String ... vals) {
        super(key, KAPair.join(vals));
        this.key = key;
        this.vals = vals;
    }

    public void setValues(String ... vals) {
        this.vals = vals;
    }

    public String[] getValues() {
        return this.vals;
    }

    private static String join(String ... vals) {
        if (vals == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < vals.length) {
            if (vals[i] != null) {
                sb.append(vals[i]);
            }
            if (++i >= vals.length) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    private static String[] encode(String ... vals) {
        if (vals == null) {
            return null;
        }
        String[] enc = new String[vals.length];
        for (int i = 0; i < vals.length; ++i) {
            enc[i] = LessBytes.urlencode(vals[i]);
        }
        return enc;
    }

    @Override
    public String toString() {
        if (this.vals == null) {
            return LessStrings.cat(LessBytes.urlencode(this.key), "=");
        }
        return LessStrings.cat(LessBytes.urlencode(this.key), "=", KAPair.join(KAPair.encode(this.vals)));
    }
}

