/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.kv;

import com.addthis.basis.util.LessBytes;
import com.addthis.basis.util.LessStrings;

public class KVPair {
    private String key;
    private String val;

    public KVPair(String key, String val) {
        this.setKeyValue(key, val);
    }

    public static KVPair parsePair(String str) {
        int sep = str.indexOf(61);
        if (sep == 0 || str.length() == 0) {
            return null;
        }
        if (sep < 0) {
            return new KVPair(LessBytes.urldecode(str), "");
        }
        if (sep < str.length() - 1) {
            return new KVPair(LessBytes.urldecode(str.substring(0, sep)), LessBytes.urldecode(str.substring(sep + 1)));
        }
        return new KVPair(LessBytes.urldecode(str.substring(0, sep)), "");
    }

    public static KVPair parseHttpHeader(String str) {
        int idx = str.indexOf(58);
        if (idx == 0) {
            return null;
        }
        if (idx > 0) {
            if (idx < str.length() - 1) {
                int si;
                for (si = idx + 1; Character.isWhitespace(str.charAt(si)) && si < str.length() - 1; ++si) {
                }
                return new KVPair(str.substring(0, idx), str.substring(si));
            }
            return new KVPair(str.substring(0, idx), "");
        }
        return new KVPair(str, "");
    }

    public void setKeyValue(String key, String val) {
        if (key == null) {
            new Exception("null key").printStackTrace();
        }
        this.setKey(key);
        this.setValue(val);
    }

    public String getKey() {
        return this.key;
    }

    public boolean keyMatch(String k) {
        return this.key.equalsIgnoreCase(k);
    }

    public void setKey(String nk) {
        this.key = nk;
    }

    public String setValue(String nv) {
        String oval = this.val;
        this.val = nv;
        return oval;
    }

    public String getValue() {
        return this.val;
    }

    public String toQuotedKeyString() {
        if (this.val == null) {
            return LessStrings.cat("\"", LessBytes.urlencode(this.key), "\"=");
        }
        return LessStrings.cat("\"", LessBytes.urlencode(this.key), "\"=", LessBytes.urlencode(this.val));
    }

    public String toString() {
        if (this.val == null) {
            return LessStrings.cat(LessBytes.urlencode(this.key), "=");
        }
        return LessStrings.cat(LessBytes.urlencode(this.key), "=", LessBytes.urlencode(this.val));
    }

    public boolean equals(KVPair other) {
        return other != null && this.getKey().equalsIgnoreCase(other.getKey()) && this.getValue().equals(other.getValue());
    }
}

