/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.kv;

import com.addthis.basis.kv.KAPair;
import com.addthis.basis.kv.KVPair;
import com.addthis.basis.util.LessBytes;
import com.addthis.basis.util.LessNumbers;
import com.addthis.basis.util.LessStrings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KVPairs
implements Iterable<KVPair> {
    protected static final Logger log = LoggerFactory.getLogger(KVPairs.class);
    private static final boolean putupper = System.getProperty("kv.putupper", "1").equals("1");
    private static final boolean getupper = System.getProperty("kv.getupper", "1").equals("1");
    private HashMap<String, KVPair> pairs;

    public static KVPairs mergeAndCopy(KVPairs base, KVPairs overrider) {
        if (overrider == null) {
            return base;
        }
        if (base == null) {
            return overrider;
        }
        KVPairs ret = overrider.getCopy();
        for (KVPair kv : base) {
            if (ret.hasKey(kv.getKey())) continue;
            ret.addValue(kv.getKey(), kv.getValue());
        }
        return ret;
    }

    public static KVPairs fromFullURL(String url) {
        KVPairs kvp = new KVPairs();
        kvp.addValue("_URLROOT_", kvp.parseURLPath(url, true));
        return kvp;
    }

    public static KVPairs clearEmpties(KVPairs values) {
        Iterator<KVPair> iter = values.elements();
        while (iter.hasNext()) {
            KVPair kv = iter.next();
            if (!LessStrings.isEmpty(kv.getValue())) continue;
            iter.remove();
        }
        return values;
    }

    private String fixGetCase(String key) {
        return getupper ? key.toUpperCase() : key;
    }

    public KVPairs() {
        this.pairs = new LinkedHashMap<String, KVPair>();
    }

    protected KVPairs(KVPairs kv) {
        this.pairs = kv.pairs;
    }

    public KVPairs(String urlpath) {
        this();
        if (urlpath != null) {
            this.parseURLPath(urlpath, false);
        }
    }

    public KVPairs(byte[] kbin) {
        this();
        this.fromBinArray(kbin);
    }

    public KVPairs getCopy() {
        KVPairs kv = new KVPairs(this);
        try {
            kv.pairs = (HashMap)this.pairs.clone();
        }
        catch (Exception ex) {
            log.trace("getCopy", (Throwable)ex);
        }
        return kv;
    }

    public String getPrintable() {
        return this.getPrintable(false);
    }

    public String getPrintable(boolean newline) {
        StringBuilder sb = new StringBuilder();
        Iterator<KVPair> i = this.pairs.values().iterator();
        while (i.hasNext()) {
            KVPair kv = i.next();
            sb.append(kv.getKey() + "='" + kv.getValue() + "'");
            if (!i.hasNext()) continue;
            sb.append(newline ? (char)'\n' : ' ');
        }
        return sb.toString();
    }

    private void parsePair(String s) {
        KVPair kv = KVPair.parsePair(s);
        if (kv != null) {
            this.addPair(kv);
        }
    }

    private void parsePairs(String s, char del) {
        if (s.length() == 0) {
            return;
        }
        int i = 0;
        int j = s.indexOf(del);
        while (j >= 0) {
            if (j > 0) {
                this.parsePair(s.substring(i, j));
            }
            i = j + 1;
            j = s.indexOf(del, i);
        }
        this.parsePair(s.substring(i));
    }

    public String parseURLPath(String urlPath, boolean lookForQ) {
        String filePath = urlPath;
        if (lookForQ) {
            int idx = urlPath.indexOf(63);
            if (idx < 0 || idx == urlPath.length()) {
                return urlPath;
            }
            filePath = urlPath.substring(0, idx);
            urlPath = urlPath.substring(idx + 1);
        }
        this.parsePairs(urlPath, '&');
        return filePath;
    }

    public KVPairs prefix(String prefix) {
        HashMap<String, KVPair> oldPairs = this.pairs;
        this.pairs = new LinkedHashMap<String, KVPair>();
        for (Map.Entry<String, KVPair> mapEntry : oldPairs.entrySet()) {
            KVPair kvpair = mapEntry.getValue();
            kvpair.setKey(prefix + kvpair.getKey());
            this.addPair(kvpair);
        }
        return this;
    }

    public synchronized KVPairs merge(KVPairs add) {
        if (add != null) {
            this.pairs.putAll(add.pairs);
        }
        return this;
    }

    public KVPairs mergeNotEmpty(KVPairs add) {
        if (add != null) {
            for (String key : add.pairs.keySet()) {
                KVPair newVal = add.getPair(key);
                KVPair thisVal = this.getPair(key);
                if (newVal == null || LessStrings.isEmpty(newVal.getValue()) || thisVal != null && !LessStrings.isEmpty(thisVal.getValue())) continue;
                this.addPair(newVal);
            }
        }
        return this;
    }

    public KVPairs add(String key, String val) {
        this.addValue(key, val);
        return this;
    }

    public KVPairs add(String key, int val) {
        return this.add(key, Integer.toString(val));
    }

    private static KVPair createPair(String key, String value) {
        return new KVPair(key, value);
    }

    public KVPair addValue(String key, String val) {
        return this.addPair(KVPairs.createPair(key, val));
    }

    public KVPair addValue(String key, int value) {
        return this.addPair(KVPairs.createPair(key, Integer.toString(value)));
    }

    public KVPair addValue(String key, long value) {
        return this.addPair(KVPairs.createPair(key, Long.toString(value)));
    }

    public KVPair addValue(String key, float value) {
        return this.addPair(KVPairs.createPair(key, Float.toString(value)));
    }

    public KVPair addValue(String key, double value) {
        return this.addPair(KVPairs.createPair(key, Double.toString(value)));
    }

    public KAPair addValue(String key, String ... values) {
        KAPair pair = new KAPair(key, values);
        this.addPair(pair);
        return pair;
    }

    public KVPair putValue(String key, String val) {
        return this.addValue(key, val);
    }

    public KVPair putValue(String key, int value) {
        return this.addValue(key, value);
    }

    public KVPair putValue(String key, long value) {
        return this.addValue(key, value);
    }

    public KVPair putValue(String key, float value) {
        return this.addValue(key, value);
    }

    public KVPair putValue(String key, double value) {
        return this.addValue(key, value);
    }

    public KAPair putValue(String key, String ... values) {
        return this.addValue(key, values);
    }

    public final synchronized KVPair addPair(KVPair pair) {
        String key = pair.getKey();
        return this.pairs.put(putupper ? key.toUpperCase() : key, pair);
    }

    public KVPair putPair(KVPair pair) {
        return this.addPair(pair);
    }

    public final void replaceOrAdd(String key, String value) {
        KVPair pair = this.getPair(key);
        if (pair != null) {
            pair.setValue(value);
        } else {
            this.addValue(key, value);
        }
    }

    public final void replaceOrAdd(String key, long value) {
        KVPair pair = this.getPair(key);
        if (pair != null) {
            pair.setValue(Long.toString(value));
        } else {
            this.addValue(key, value);
        }
    }

    public final void replaceOrAdd(String key, int value) {
        KVPair pair = this.getPair(key);
        if (pair != null) {
            pair.setValue(Integer.toString(value));
        } else {
            this.addValue(key, value);
        }
    }

    public final boolean renameValue(String okey, String nkey) {
        KVPair p = this.pairs.remove(this.fixGetCase(okey));
        if (p != null) {
            p.setKey(nkey);
            this.addPair(p);
            return true;
        }
        return false;
    }

    public final KVPair removePair(String key) {
        return this.pairs.remove(this.fixGetCase(key));
    }

    public String takeValue(String key) {
        KVPair p = this.removePair(key);
        return p != null ? p.getValue() : null;
    }

    public String takeValue(String key, String def) {
        KVPair p = this.removePair(key);
        return p != null ? p.getValue() : def;
    }

    public int takeValue(String key, int def) {
        return this.takeValue(key, def, 10);
    }

    public int takeValue(String key, int def, int base) {
        String val = this.takeValue(key);
        return val != null ? LessNumbers.parseInt(val, def, base) : def;
    }

    public float takeValue(String key, float def) {
        String val = this.takeValue(key);
        return val != null ? LessNumbers.parseFloat(val, def) : def;
    }

    public long takeValue(String key, long def) {
        return this.takeValue(key, def, 10);
    }

    public long takeValue(String key, long def, int base) {
        String val = this.takeValue(key);
        return val != null ? LessNumbers.parseLong(val, def, base) : def;
    }

    public final synchronized KVPair getPair(String key) {
        return this.pairs.get(this.fixGetCase(key));
    }

    public final boolean hasKey(String key) {
        if (key == null) {
            return false;
        }
        return this.pairs.containsKey(this.fixGetCase(key));
    }

    public final boolean hasPair(KVPair pair) {
        return pair != null && pair.equals(this.getPair(pair.getKey()));
    }

    public String getValue(String key) {
        return this.getValue(key, null);
    }

    public String getValue(String key, String def) {
        KVPair pair = this.getPair(key);
        return pair != null ? pair.getValue() : def;
    }

    public int getIntValue(String key, int def) {
        return this.getIntValue(10, key, def);
    }

    public int getIntValue(int radix, String key, int def) {
        KVPair pair = this.getPair(key);
        return pair != null ? LessNumbers.parseInt(pair.getValue(), def, radix) : def;
    }

    public long getLongValue(String key, long def) {
        return this.getLongValue(10, key, def);
    }

    public long getLongValue(int radix, String key, long def) {
        KVPair pair = this.getPair(key);
        return pair != null ? LessNumbers.parseLong(pair.getValue(), def, radix) : def;
    }

    public float getFloatValue(String key, float def) {
        String val = this.getValue(key);
        return val != null ? LessNumbers.parseFloat(val, def) : def;
    }

    public double getDoubleValue(String key, double def) {
        String val = this.getValue(key);
        return val != null ? LessNumbers.parseDouble(val, def) : def;
    }

    public final String setValue(String key, String value) {
        String oval = null;
        KVPair p = this.getPair(key);
        if (p != null) {
            oval = p.getValue();
            p.setValue(value);
        }
        return oval;
    }

    public final int count() {
        return this.pairs.size();
    }

    public final Iterator<String> keys() {
        return this.pairs.keySet().iterator();
    }

    public final Set<String> keySet() {
        return this.pairs.keySet();
    }

    public final Collection<KVPair> values() {
        return this.pairs.values();
    }

    @Override
    public Iterator<KVPair> iterator() {
        return this.elements();
    }

    public final Iterator<KVPair> elements() {
        return this.pairs.values().iterator();
    }

    public String toURLParams() {
        return this.toString();
    }

    public void fromURLParams(String str) {
        this.parseURLPath(str, false);
    }

    public byte[] toBinArray() {
        int size = 0;
        ArrayList<byte[]> arr = new ArrayList<byte[]>(this.count() * 2);
        for (KVPair kv : this.values()) {
            String v = kv.getValue();
            byte[] key = LessBytes.toBytes(kv.getKey());
            byte[] val = v != null ? LessBytes.toBytes(kv.getValue()) : new byte[]{};
            size += key.length + val.length;
            arr.add(key);
            arr.add(val);
        }
        byte[] out = new byte[size + arr.size()];
        size = 0;
        for (byte[] el : arr) {
            for (int i = 0; i < el.length; ++i) {
                out[size + i] = el[i] != 0 ? el[i] : 32;
            }
            out[(size += el.length + 1) - 1] = 0;
        }
        return out;
    }

    public KVPairs fromBinArray(byte[] bin) {
        int pos = 0;
        while (pos < bin.length) {
            int i;
            String key = null;
            String val = null;
            for (i = pos; i < bin.length; ++i) {
                if (bin[i] == 0) {
                    key = new String(bin, pos, i - pos);
                    pos = i + 1;
                    break;
                }
                if (i != bin.length - 1) continue;
                key = new String(bin, pos, i - pos + 1);
                pos = i + 1;
                break;
            }
            for (i = pos; i < bin.length; ++i) {
                if (bin[i] == 0) {
                    val = new String(bin, pos, i - pos);
                    pos = i + 1;
                    break;
                }
                if (i != bin.length - 1) continue;
                val = new String(bin, pos, i - pos + 1);
                pos = i + 1;
                break;
            }
            this.addValue(key, val);
        }
        return this;
    }

    public synchronized String toQuotedKeyString() {
        StringBuilder sb = new StringBuilder();
        Iterator<KVPair> i = this.pairs.values().iterator();
        while (i.hasNext()) {
            sb.append(i.next().toQuotedKeyString());
            if (!i.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        Iterator<KVPair> i = this.pairs.values().iterator();
        while (i.hasNext()) {
            sb.append(i.next().toString());
            if (!i.hasNext()) continue;
            sb.append("&");
        }
        return sb.toString();
    }

    public synchronized boolean equals(KVPairs other) {
        if (!this.keySet().equals(other.keySet())) {
            return false;
        }
        for (String key : this.keySet()) {
            if (this.getPair(key).equals(other.getPair(key))) continue;
            return false;
        }
        return true;
    }

    public KVPairs(String ka, String va) {
        this();
        this.addValue(ka, va);
    }

    public KVPairs(String ka, String va, String kb, String vb) {
        this();
        this.addValue(ka, va);
        this.addValue(kb, vb);
    }

    public KVPairs(String ka, String va, String kb, String vb, String kc, String vc) {
        this();
        this.addValue(ka, va);
        this.addValue(kb, vb);
        this.addValue(kc, vc);
    }

    public KVPairs(String ka, String va, String kb, String vb, String kc, String vc, String kd, String vd) {
        this();
        this.addValue(ka, va);
        this.addValue(kb, vb);
        this.addValue(kc, vc);
        this.addValue(kd, vd);
    }
}

