/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.kv;

import com.addthis.basis.kv.KVPair;
import com.addthis.basis.kv.KVPairs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class KVTable {
    List<String> cols = new LinkedList<String>();
    List<KVPairs> data = new ArrayList<KVPairs>();
    HashMap<String, String> colMap;

    public KVTable() {
        this.colMap = new HashMap();
    }

    public KVTable(HashMap<String, String> map) {
        this.colMap = map;
    }

    public void addRows(Iterator<KVPairs> iter, int count) {
        for (int i = 0; iter.hasNext() && (count == 0 || i < count); ++i) {
            this.addRow(iter.next());
        }
    }

    public void addRow(KVPairs row) {
        Iterator<KVPair> e = row.elements();
        while (e.hasNext()) {
            this.addColumn(e.next().getKey());
        }
        this.data.add(row);
    }

    public void addColumn(String col) {
        if (!this.cols.contains(col = col.toLowerCase())) {
            this.cols.add(col);
        }
    }

    public void clearData() {
        this.data.clear();
    }

    public Iterator<String> getColumns() {
        return this.cols.iterator();
    }

    public List<String> getColumnList() {
        return this.cols;
    }

    public List<String> getColumn(String key) {
        LinkedList<String> list = new LinkedList<String>();
        Iterator<KVPairs> iter = this.getRows();
        while (iter.hasNext()) {
            list.add(iter.next().getValue(key));
        }
        return list;
    }

    public int getColumnCount() {
        return this.cols.size();
    }

    public String getColumnKey(int pos) {
        return this.cols.get(pos);
    }

    public String getColumnName(String colKey) {
        String name = this.colMap.get(colKey);
        return name != null ? name : colKey;
    }

    public Iterator<KVPairs> getRows() {
        return this.data.iterator();
    }

    public List<KVPairs> getRowList() {
        return this.data;
    }

    public int getRowCount() {
        return this.data.size();
    }

    public String exportCSV() {
        return this.exportCSV(true);
    }

    public String exportCSV(boolean sortcols) {
        StringBuilder sb = new StringBuilder();
        LinkedList<String> columns = new LinkedList<String>();
        Iterator<String> cols = this.getColumns();
        while (cols.hasNext()) {
            columns.add(cols.next());
        }
        if (sortcols) {
            Collections.sort(columns);
        }
        cols = columns.iterator();
        while (cols.hasNext()) {
            sb.append(cols.next());
            if (!cols.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("\n");
        Iterator<KVPairs> rows = this.getRows();
        while (rows.hasNext()) {
            KVPairs row = rows.next();
            Iterator cols2 = columns.iterator();
            while (cols2.hasNext()) {
                String col = (String)cols2.next();
                String val = row.getValue(col, "");
                sb.append(val.replace(',', ' '));
                if (!cols2.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public synchronized void pivot(String column) {
        ArrayList<KVPairs> nudata = new ArrayList<KVPairs>();
        ArrayList<String> nucols = new ArrayList<String>();
        nucols.add(column);
        boolean first = true;
        for (String col : this.cols) {
            if (col.equals(column)) continue;
            KVPairs nd = new KVPairs();
            for (KVPairs kv : this.data) {
                String colname = kv.getValue(column);
                nd.addValue(column, col);
                nd.addValue(colname, kv.getValue(col));
                if (!first || nucols.contains(colname.toLowerCase())) continue;
                nucols.add(colname);
            }
            first = false;
            nudata.add(nd);
        }
        this.data = nudata;
        this.cols = nucols;
    }
}

