/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.net;

import com.addthis.basis.net.HttpUtil;
import com.addthis.basis.net.http.HttpResponse;
import com.addthis.basis.util.AdjustableSemaphore;
import java.io.IOException;
import javax.naming.ServiceUnavailableException;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstrainedHttpClient {
    private static final Logger logger = LoggerFactory.getLogger(ConstrainedHttpClient.class);
    protected AdjustableSemaphore semaphore;

    public ConstrainedHttpClient(int maxConcurrentRequests) {
        this.semaphore = new AdjustableSemaphore(maxConcurrentRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse execute(HttpRequestBase request, int timeoutms) throws ServiceUnavailableException, IOException {
        if (this.semaphore.tryAcquire()) {
            try {
                logger.trace("Semaphore was acquired. Remaining: {} ", (Object)this.semaphore.availablePermits());
                HttpResponse httpResponse = HttpUtil.execute((HttpUriRequest)request, timeoutms);
                return httpResponse;
            }
            finally {
                this.semaphore.release();
            }
        }
        throw new ServiceUnavailableException("Reached limit of " + this.getCurrentRequests() + " concurrent requests");
    }

    public int getCurrentRequests() {
        return this.semaphore.maxPermits() - this.semaphore.availablePermits();
    }

    public void setMaxConcurrentRequests(int maxConcurrentRequests) {
        this.semaphore.setMaxPermits(maxConcurrentRequests);
    }
}

