/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.net;

import com.addthis.basis.net.http.HttpResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;

public class HttpUtil {
    public static HttpResponse httpGet(String url, int timeoutms) throws IOException, URISyntaxException {
        return HttpUtil.httpGet(url, null, timeoutms);
    }

    public static HttpResponse httpGet(String url, Map<String, String> requestHeaders, int timeoutms) throws IOException, URISyntaxException {
        HttpGet get = new HttpGet(new URI(url));
        if (requestHeaders != null) {
            for (Map.Entry<String, String> entry : requestHeaders.entrySet()) {
                get.addHeader(entry.getKey(), entry.getValue());
            }
        }
        return HttpUtil.execute((HttpUriRequest)get, timeoutms);
    }

    public static InputStream httpGetAsInputStream(String url, int timeoutms) throws IOException, URISyntaxException {
        byte[] data = HttpUtil.httpGet(url, null, timeoutms).getBody();
        return data == null ? null : new ByteArrayInputStream(data);
    }

    public static HttpResponse httpPost(String url, String contentType, byte[] content, int timeoutms) throws IOException {
        return HttpUtil.execute((HttpUriRequest)HttpUtil.makePost(url, contentType, content), timeoutms);
    }

    public static HttpResponse httpPost(String url, String charset, Map<String, String> content, int timeoutms) throws IOException {
        return HttpUtil.execute((HttpUriRequest)HttpUtil.makePost(url, charset, content), timeoutms);
    }

    public static HttpPost makePost(String url, String contentType, byte[] content) {
        HttpPost post = new HttpPost(url);
        ContentType type = contentType == null ? null : ContentType.parse((String)contentType);
        post.setEntity((HttpEntity)new ByteArrayEntity(content, type));
        return post;
    }

    public static HttpPost makePost(String url, String charset, Map<String, String> content) throws UnsupportedEncodingException {
        HttpPost post = new HttpPost(url);
        ArrayList<BasicNameValuePair> pairs = new ArrayList<BasicNameValuePair>(content.size());
        for (Map.Entry<String, String> entry : content.entrySet()) {
            pairs.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
        }
        UrlEncodedFormEntity entity = new UrlEncodedFormEntity(pairs, charset);
        post.setEntity((HttpEntity)entity);
        return post;
    }

    public static List<byte[]> httpGet(List<String> urls, int numThreads, int timeoutms) {
        ArrayList<HttpGet> methods = new ArrayList<HttpGet>();
        for (String url : urls) {
            methods.add(new HttpGet(url));
        }
        List<Method> responses = HttpUtil.execute(methods, numThreads, timeoutms);
        return HttpUtil.extractResponses(responses);
    }

    /*
     * Loose catch block
     */
    public static HttpResponse execute(HttpUriRequest request, int timeoutms) throws IOException {
        HttpClientBuilder builder = HttpClientBuilder.create();
        try (CloseableHttpResponse response = null;){
            try (CloseableHttpClient client = HttpUtil.makeCloseableHttpClient(timeoutms, 0);){
                response = client.execute(request);
                HttpResponse httpResponse = new HttpResponse(response);
                return httpResponse;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    /*
     * Loose catch block
     */
    public static HttpResponse execute(HttpUriRequest request, int timeoutms, int numRetries) throws IOException {
        try (CloseableHttpResponse response = null;){
            try (CloseableHttpClient client = HttpUtil.makeCloseableHttpClient(timeoutms, numRetries);){
                response = client.execute(request);
                HttpResponse httpResponse = new HttpResponse(response);
                return httpResponse;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
    }

    public static List<Method> execute(List<? extends HttpRequestBase> requests, int numThreads, int timeoutms) {
        return HttpUtil.execute(requests, numThreads, timeoutms, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Method> execute(List<? extends HttpRequestBase> requests, int numThreads, int timeoutms, int numRetries) {
        ArrayList<Method> responses = new ArrayList<Method>();
        ExecutorService executor = Executors.newFixedThreadPool(Math.min(numThreads, requests.size()));
        CloseableHttpClient client = HttpUtil.makeCloseableHttpClient(timeoutms, numRetries);
        try {
            for (int i = 0; i < requests.size(); ++i) {
                Method method = new Method(client, requests.get(i), timeoutms);
                responses.add(i, method);
                executor.execute(method);
            }
            executor.shutdown();
            try {
                if (timeoutms > 0) {
                    executor.awaitTermination(2 * timeoutms * requests.size() / numThreads, TimeUnit.MILLISECONDS);
                } else {
                    executor.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            if (!executor.isTerminated()) {
                executor.shutdownNow();
                executor = null;
            }
            ArrayList<Method> arrayList = responses;
            return arrayList;
        }
        finally {
            if (executor != null) {
                executor.shutdownNow();
            }
            try {
                client.close();
            }
            catch (IOException ignored) {}
        }
    }

    private static CloseableHttpClient makeCloseableHttpClient(int timeoutms, int numRetries) {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (numRetries >= 0) {
            DefaultHttpRequestRetryHandler retryHandler = new DefaultHttpRequestRetryHandler(numRetries, false);
            builder = builder.setRetryHandler((HttpRequestRetryHandler)retryHandler);
        }
        if (timeoutms > 0) {
            RequestConfig config = RequestConfig.custom().setConnectTimeout(timeoutms).setConnectionRequestTimeout(timeoutms).setSocketTimeout(timeoutms).build();
            builder.setDefaultRequestConfig(config);
        }
        return builder.build();
    }

    public static List<byte[]> extractResponses(List<Method> methods) {
        byte[][] responses = new byte[methods.size()][];
        int i = 0;
        for (Method method : methods) {
            if (method.status < 400) {
                responses[i] = method.body;
            }
            ++i;
        }
        return Arrays.asList(responses);
    }

    private static class Method
    implements Runnable {
        private final CloseableHttpClient client;
        private final HttpContext context;
        public final HttpRequestBase request;
        public int status;
        public byte[] body;

        public Method(CloseableHttpClient client, HttpRequestBase request, int timeoutms) {
            this.client = client;
            this.request = request;
            this.context = HttpClientContext.create();
        }

        @Override
        public void run() {
            CloseableHttpResponse response = null;
            try {
                response = this.client.execute((HttpUriRequest)this.request, this.context);
                HttpEntity entity = response.getEntity();
                this.status = response.getStatusLine().getStatusCode();
                this.body = entity == null ? null : EntityUtils.toByteArray((HttpEntity)entity);
            }
            catch (Exception ignored) {
            }
            finally {
                try {
                    if (response != null) {
                        response.close();
                    }
                }
                catch (Exception ignored) {}
            }
        }
    }
}

