/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.net;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public final class NetUtil {
    private static final String localDomain = System.getProperty("net.domain", ".localhost");
    private static final String localHost = System.getProperty("net.host");
    public static final byte[] hex = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    public static Host parseHost(String str) {
        return NetUtil.parseHost(str, 0);
    }

    public static Host parseHost(String str, int defaultPort) {
        StringTokenizer st = new StringTokenizer(str, ":");
        String host = st.nextToken();
        int port = st.hasMoreTokens() ? Integer.parseInt(st.nextToken()) : defaultPort;
        return new Host(host, port);
    }

    public static List<Host> parseHostList(String str) {
        LinkedList<Host> ll = new LinkedList<Host>();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String nt = st.nextToken();
            ll.add(NetUtil.parseHost(nt));
        }
        return ll;
    }

    public static boolean hostNameMatch(String hostname, List<Host> list) {
        if (list == null || hostname == null) {
            return false;
        }
        for (Host aList : list) {
            if (!aList.matchName(hostname)) continue;
            return true;
        }
        return false;
    }

    public static boolean hostNameMatch(InetAddress host, List<Host> list) {
        if (list == null || host == null) {
            return false;
        }
        return NetUtil.hostNameMatch(host.getHostName(), list);
    }

    public static byte[] getInetAddressAsHex(InetAddress addr) {
        byte[] raddr = addr.getAddress();
        byte[] naddr = new byte[raddr.length * 2];
        for (int i = 0; i < raddr.length; ++i) {
            naddr[i * 2] = hex[raddr[i] >> 4 & 0xF];
            naddr[i * 2 + 1] = hex[raddr[i] & 0xF];
        }
        return naddr;
    }

    public static InetAddress getInetAddressFromHex(String hex) throws UnknownHostException {
        byte[] addr = new byte[hex.length() / 2];
        for (int i = 0; i < addr.length; ++i) {
            addr[i] = (byte)(Integer.parseInt(hex.substring(i * 2, i * 2 + 2), 16) & 0xFF);
        }
        return InetAddress.getByAddress(addr);
    }

    public static String inferDomain() {
        try {
            String myHostName = localHost != null ? localHost : InetAddress.getLocalHost().getHostName();
            int lio = myHostName.indexOf(46);
            if (lio > 0) {
                return myHostName.substring(lio);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return localDomain;
    }

    public static String getBaseDomain(String host) {
        return NetUtil.getBaseDomain(host, true);
    }

    public static String getBaseDomain(String host, boolean tight) {
        int he = host.length();
        if (he < 5) {
            return host;
        }
        char lastChar = (host = host.toLowerCase()).charAt(he - 1);
        if (lastChar == '.') {
            --he;
        }
        int of = host.indexOf(46);
        int d1 = host.lastIndexOf(46, he - 1);
        int d2 = d1 > 0 ? host.lastIndexOf(46, d1 - 1) : -1;
        int d3 = d2 > 0 ? host.lastIndexOf(46, d2 - 1) : -1;
        boolean lastNum = host.charAt(he - 1) - 48 < 10;
        boolean common = he - d1 == 4;
        int hs = 0;
        if (!lastNum && (host.startsWith("www.") || tight && (d2 > 0 && d1 > d2 && common || d3 > 0 && d2 > d3))) {
            hs += of + 1;
        }
        host = host.substring(hs, he);
        return host;
    }

    public static String resolveDottedIP(String ip) {
        if (ip.length() == 0 || !Character.isDigit(ip.charAt(ip.length() - 1)) || !Character.isDigit(ip.charAt(0))) {
            return ip;
        }
        try {
            String newhost = InetAddress.getByName(ip).getHostName();
            if (newhost != null) {
                return newhost;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ip;
    }

    public static long ipToLong(String ip) {
        if (ip == null) {
            return -1L;
        }
        String[] parts = ip.split("\\.");
        try {
            return Long.parseLong(parts[0]) << 24 | Long.parseLong(parts[1]) << 16 | Long.parseLong(parts[2]) << 8 | Long.parseLong(parts[3]);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return -1L;
        }
    }

    public static String longToIp(long i) {
        return (i >> 24 & 0xFFL) + "." + (i >> 16 & 0xFFL) + "." + (i >> 8 & 0xFFL) + "." + (i & 0xFFL);
    }

    public static class Host {
        public String name;
        public int port;

        public Host(InetSocketAddress addr) {
            this.name = addr.getHostName();
            this.port = addr.getPort();
        }

        public Host(String name, int port) {
            this.name = name;
            this.port = port;
        }

        public String toString() {
            return this.name + ":" + this.port;
        }

        public InetSocketAddress getAddress() {
            return new InetSocketAddress(this.name, this.port);
        }

        public boolean matchName(String hostname) {
            if (hostname.equals(this.name)) {
                return true;
            }
            try {
                if (hostname.startsWith(".")) {
                    return this.name.endsWith(hostname) || InetAddress.getByName(this.name).getHostName().endsWith(hostname);
                }
                if (this.name.startsWith(".")) {
                    return hostname.endsWith(this.name) || InetAddress.getByName(hostname).getHostName().endsWith(this.name);
                }
                return InetAddress.getByName(hostname).getHostAddress().equals(this.name) || InetAddress.getByName(this.name).getHostAddress().equals(hostname);
            }
            catch (UnknownHostException unknownHostException) {
                return false;
            }
        }
    }
}

