/*
 * Decompiled with CFR 0.152.
 */
package com.addthis.basis.net.http;

import com.addthis.basis.net.http.HttpHeader;
import com.addthis.basis.util.Multidict;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Collection;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.util.EntityUtils;

public class HttpResponse {
    private static final ObjectMapper mapper = new ObjectMapper();
    private final int status;
    private final String reason;
    private final Multidict headers;
    private final byte[] body;

    public HttpResponse(CloseableHttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        this.status = response.getStatusLine().getStatusCode();
        this.reason = response.getStatusLine().getReasonPhrase();
        this.body = entity == null ? null : EntityUtils.toByteArray((HttpEntity)entity);
        this.headers = new Multidict();
        for (Header header : response.getAllHeaders()) {
            this.headers.put(header.getName(), header.getValue());
        }
    }

    public int getStatus() {
        return this.status;
    }

    public String getReason() {
        return this.reason;
    }

    public String getHeader(HttpHeader httpHeader) {
        return this.getHeaders().get(httpHeader.toString());
    }

    public Collection<String> getHeaders(HttpHeader httpHeader) {
        return this.getHeaders().getAll(httpHeader.toString());
    }

    public Multidict getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public <T> T getBody(TypeReference<T> type) throws IOException {
        return (T)mapper.readValue(new String(this.getBody()), type);
    }

    public <T> T getBody(Class<T> type) throws IOException {
        return (T)mapper.readValue(new String(this.getBody()), type);
    }
}

